/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentUnindentHandlerBase;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler$ForEachCaret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doExecuteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "doIndentUnindent", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "document", "Lcom/intellij/openapi/editor/Document;", "executeWriteAction", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getFirstLinesOfSelectedItems", "", "", "isEnabledForCaret", "updateNumbering", "intellij.markdown.core"})
public abstract class ListItemIndentUnindentHandlerBase
extends EditorWriteActionHandler.ForEachCaret {
    @Nullable
    private final EditorActionHandler baseHandler;

    public ListItemIndentUnindentHandlerBase(@Nullable EditorActionHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        EditorActionHandler editorActionHandler = this.baseHandler;
        return editorActionHandler != null ? editorActionHandler.isEnabled(editor2, caret, dataContext) : false;
    }

    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            boolean enabled = MarkdownCodeInsightSettings.Companion.getInstance().getState().getAdjustListIndentation();
            if (caret != null && enabled && this.doExecuteAction(editor2, caret)) break block1;
            EditorActionHandler editorActionHandler = this.baseHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(editor2, caret, dataContext);
            }
        }
    }

    private final boolean doExecuteAction(Editor editor2, Caret caret) {
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiFile psiFile = psiDocumentManager.getPsiFile(document2);
        MarkdownFile markdownFile = psiFile instanceof MarkdownFile ? (MarkdownFile)psiFile : null;
        if (markdownFile == null) {
            return false;
        }
        MarkdownFile file = markdownFile;
        List<Integer> firstLinesOfSelectedItems = this.getFirstLinesOfSelectedItems(caret, document2, file);
        boolean indentPerformed = false;
        Iterator<Integer> iterator = firstLinesOfSelectedItems.iterator();
        while (iterator.hasNext()) {
            MarkdownListItem item;
            MarkdownListItem item2;
            int line = ((Number)iterator.next()).intValue();
            psiDocumentManager.commitDocument(document2);
            Intrinsics.checkNotNull((Object)ListUtils.INSTANCE.getListItemAtLine(file, line, document2));
            if (!this.doIndentUnindent(item2, file, document2)) continue;
            indentPerformed = true;
            if (!MarkdownCodeInsightSettings.Companion.getInstance().getState().getRenumberListsOnType()) continue;
            psiDocumentManager.commitDocument(document2);
            Intrinsics.checkNotNull((Object)ListUtils.INSTANCE.getListItemAtLine(file, line, document2));
            this.updateNumbering(item, file, document2);
        }
        return !((Collection)firstLinesOfSelectedItems).isEmpty() && indentPerformed;
    }

    private final List<Integer> getFirstLinesOfSelectedItems(Caret caret, Document document, MarkdownFile file) {
        int line = document.getLineNumber(caret.getSelectionStart());
        int lastLine = caret.hasSelection() ? document.getLineNumber(caret.getSelectionEnd() - 1) : line;
        List lines2 = new ArrayList();
        while (line <= lastLine) {
            MarkdownListItem item = ListUtils.INSTANCE.getListItemAtLine(file, line, document);
            if (item == null) {
                ++line;
                continue;
            }
            lines2.add(line);
            line = document.getLineNumber(UtilsKt.getEndOffset((PsiElement)((PsiElement)item))) + 1;
        }
        return lines2;
    }

    protected abstract boolean doIndentUnindent(@NotNull MarkdownListItem var1, @NotNull MarkdownFile var2, @NotNull Document var3);

    protected abstract void updateNumbering(@NotNull MarkdownListItem var1, @NotNull MarkdownFile var2, @NotNull Document var3);
}

