/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceUtils;", "", "()V", "getCodeFence", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "element", "Lcom/intellij/psi/PsiElement;", "getContent", "", "host", "withWhitespaces", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl;", "getEmptyRange", "Lcom/intellij/openapi/util/TextRange;", "getIndent", "", "inCodeFence", "node", "Lcom/intellij/lang/ASTNode;", "isAbleToAcceptInjections", "isCodeFence", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownCodeFenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCodeFenceUtils.kt\norg/intellij/plugins/markdown/injection/MarkdownCodeFenceUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,147:1\n1229#2,2:148\n1#3:150\n12541#4,2:151\n12541#4,2:153\n12904#4,3:155\n*S KotlinDebug\n*F\n+ 1 MarkdownCodeFenceUtils.kt\norg/intellij/plugins/markdown/injection/MarkdownCodeFenceUtils\n*L\n30#1:148,2\n86#1:151,2\n87#1:153,2\n91#1:155,3\n*E\n"})
public final class MarkdownCodeFenceUtils {
    @NotNull
    public static final MarkdownCodeFenceUtils INSTANCE = new MarkdownCodeFenceUtils();

    private MarkdownCodeFenceUtils() {
    }

    public final boolean isCodeFence(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = MarkdownTokenTypeSets.CODE_FENCE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE");
        return AstUtilsKt.hasType(node, iElementType);
    }

    public final boolean inCodeFence(@NotNull ASTNode node) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Sequence<ASTNode> $this$any$iv = AstUtilsKt.parents(node, false);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                IElementType iElementType = MarkdownTokenTypeSets.CODE_FENCE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE");
                if (!AstUtilsKt.hasType(it, iElementType)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @Deprecated(message="Use getContent(MarkdownCodeFence) instead.")
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static final List<PsiElement> getContent(@NotNull MarkdownCodeFenceImpl host, boolean withWhitespaces) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement psiElement = host.getFirstChild();
        if (psiElement == null || (psiElement = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true)) == null) {
            return null;
        }
        PsiElement children2 = psiElement;
        List elements2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)children2, (Function1)((Function1)new Function1<PsiElement, Boolean>(withWhitespaces){
            final /* synthetic */ boolean $withWhitespaces;
            {
                this.$withWhitespaces = $withWhitespaces;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !(it instanceof OuterLanguageElement) && (Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || MarkdownPsiUtil.WhiteSpaces.isNewLine(it) || this.$withWhitespaces && MarkdownTokenTypeSets.WHITE_SPACES.contains(PsiTreeUtilKt.getElementType((PsiElement)it)));
            }
        })));
        if (!((Collection)elements2).isEmpty() && MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)CollectionsKt.first((List)elements2))) {
            elements2 = CollectionsKt.drop((Iterable)elements2, (int)1);
        }
        if (!((Collection)elements2).isEmpty() && MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)CollectionsKt.last((List)elements2))) {
            elements2 = CollectionsKt.dropLast((List)elements2, (int)1);
        }
        List it = list2 = elements2;
        boolean bl = false;
        return !((Collection)it).isEmpty() ? list2 : null;
    }

    @JvmStatic
    @Nullable
    public static final List<PsiElement> getContent(@NotNull MarkdownCodeFence host, boolean withWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return MarkdownCodeFenceUtils.getContent((MarkdownCodeFenceImpl)host, withWhitespaces);
    }

    @JvmStatic
    @Deprecated(message="Use isAbleToAcceptInjections(MarkdownCodeFence) instead.")
    @ApiStatus.ScheduledForRemoval
    public static final boolean isAbleToAcceptInjections(@NotNull MarkdownCodeFenceImpl host) {
        block8: {
            block7: {
                boolean bl;
                block6: {
                    boolean bl2;
                    PsiElement it;
                    boolean $i$f$all;
                    Object[] $this$all$iv;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                        PsiElement[] psiElementArray = host.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
                        $this$all$iv = psiElementArray;
                        $i$f$all = false;
                        for (Object element$iv : $this$all$iv) {
                            it = (PsiElement)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_END;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_END");
                            if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                            bl2 = false;
                            break block5;
                        }
                        bl2 = true;
                    }
                    if (bl2) break block7;
                    PsiElement[] psiElementArray = host.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
                    $this$all$iv = psiElementArray;
                    $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        it = (PsiElement)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_START");
                        if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (!bl) break block8;
            }
            return false;
        }
        PsiElement[] psiElementArray = host.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
        Object[] $this$count$iv = psiElementArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!MarkdownPsiUtil.WhiteSpaces.isNewLine(it)) continue;
            ++count$iv;
        }
        int newlines = count$iv;
        return newlines >= 2;
    }

    @JvmStatic
    public static final boolean isAbleToAcceptInjections(@NotNull MarkdownCodeFence host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return MarkdownCodeFenceUtils.isAbleToAcceptInjections((MarkdownCodeFenceImpl)host);
    }

    @JvmStatic
    @Deprecated(message="Use getEmptyRange(MarkdownCodeFence) instead.")
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final TextRange getEmptyRange(@NotNull MarkdownCodeFenceImpl host) {
        PsiElement start;
        PsiElement psiElement;
        Object object;
        PsiElement it;
        block3: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            PsiElement[] psiElementArray = host.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
            for (Object object2 : (Object[])psiElementArray) {
                it = (PsiElement)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                IElementType iElementType = MarkdownTokenTypes.FENCE_LANG;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"FENCE_LANG");
                if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        if ((psiElement = (PsiElement)object) == null) {
            Object object3;
            block4: {
                PsiElement[] psiElementArray = host.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
                for (Object object2 : (Object[])psiElementArray) {
                    it = (PsiElement)object2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CODE_FENCE_START");
                    if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                    object3 = object2;
                    break block4;
                }
                object3 = null;
            }
            psiElement = (PsiElement)object3;
        }
        PsiElement psiElement2 = start = psiElement;
        Intrinsics.checkNotNull((Object)psiElement2);
        TextRange textRange = TextRange.from((int)(psiElement2.getStartOffsetInParent() + start.getTextLength() + 1), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(start!!.startOffset\u2026 start.textLength + 1, 0)");
        return textRange;
    }

    @NotNull
    public final TextRange getEmptyRange(@NotNull MarkdownCodeFence host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return MarkdownCodeFenceUtils.getEmptyRange(host);
    }

    @Nullable
    public final MarkdownCodeFence getCodeFence(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)element2.getProject()).getInjectionHost(element2);
        MarkdownCodeFence markdownCodeFence = psiLanguageInjectionHost instanceof MarkdownCodeFence ? (MarkdownCodeFence)psiLanguageInjectionHost : null;
        if (markdownCodeFence == null) {
            markdownCodeFence = (MarkdownCodeFence)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownCodeFence.class);
        }
        return markdownCodeFence;
    }

    @JvmStatic
    @Nullable
    public static final String getIndent(@NotNull MarkdownCodeFence element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Document document = PsiDocumentManager.getInstance((Project)element2.getProject()).getDocument(element2.getContainingFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int offset = element2.getTextOffset();
        int lineStartOffset = document2.getLineStartOffset(document2.getLineNumber(offset));
        String string = document2.getText(TextRange.create((int)lineStartOffset, (int)offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026lineStartOffset, offset))");
        CharSequence charSequence = string;
        Regex regex = new Regex("[^> ]");
        String string2 = " ";
        return regex.replace(charSequence, string2);
    }
}

