/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.images.ConfigureImageDialog;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.InsertImageAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/InsertImageAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildImageText", "", "imageData", "Lorg/intellij/plugins/markdown/editor/images/MarkdownImageData;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.markdown.core"})
public final class InsertImageAction
extends DumbAwareAction {
    public InsertImageAction() {
        this.addTextOverride(MarkdownActionPlaces.getINSERT_POPUP(), InsertImageAction::_init_$lambda$0);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findMarkdownEditor(event);
        Presentation $this$update_u24lambda_u241 = presentation = event.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u241.setVisible(editor2 != null);
        Editor editor3 = editor2;
        $this$update_u24lambda_u241.setEnabled(editor3 != null && (editor3 = editor3.getDocument()) != null ? editor3.isWritable() : false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = MarkdownActionUtil.findRequiredMarkdownEditor(event);
        Project project = editor2.getProject();
        String string = MarkdownBundle.message("markdown.insert.image.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.insert.image.dialog.title\")");
        new ConfigureImageDialog(project, string, null, null, null, null, null, false, 252, null).show((Function1<? super MarkdownImageData, Unit>)((Function1)new Function1<MarkdownImageData, Unit>(editor2, this, project){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ InsertImageAction this$0;
            final /* synthetic */ Project $project;
            {
                this.$editor = $editor;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull MarkdownImageData imageData) {
                Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                Document document2 = document;
                String imageText = InsertImageAction.access$buildImageText(this.this$0, imageData);
                try {
                    WriteCommandAction.runWriteCommandAction((Project)this.$project, (String)this.this$0.getTemplateText(), null, () -> actionPerformed.1.invoke$lambda$1(this.$editor, document2, imageText), (PsiFile[])new PsiFile[0]);
                }
                catch (ReadOnlyModificationException exception) {
                    Messages.showErrorDialog((Project)this.$project, (String)exception.getLocalizedMessage(), (String)RefactoringBundle.message((String)"error.title"));
                }
                catch (ReadOnlyFragmentModificationException exception) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document2).handle(exception);
                }
            }

            private static final void invoke$lambda$1$lambda$0(Document $document, String $imageText, Caret caret) {
                Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                Intrinsics.checkNotNullParameter((Object)$imageText, (String)"$imageText");
                Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                int offset = caret.getOffset();
                $document.insertString(offset, (CharSequence)$imageText);
                caret.moveToOffset(offset + $imageText.length());
            }

            private static final void invoke$lambda$1(Editor $editor, Document $document, String $imageText) {
                Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
                Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                Intrinsics.checkNotNullParameter((Object)$imageText, (String)"$imageText");
                $editor.getCaretModel().runForEachCaret(arg_0 -> actionPerformed.1.invoke$lambda$1$lambda$0($document, $imageText, arg_0));
            }
        }));
    }

    private final String buildImageText(MarkdownImageData imageData) {
        String string;
        if (imageData.getShouldConvertToHtml()) {
            string = ImageUtils.createHtmlImageText(imageData);
        } else {
            String path = imageData.component1();
            String title = imageData.component4();
            String description = imageData.component5();
            string = ImageUtils.createMarkdownImageText(description, path, title);
        }
        return string;
    }

    private static final String _init_$lambda$0() {
        return MarkdownBundle.message("action.org.intellij.plugins.markdown.ui.actions.styling.InsertImageAction.insert.popup.text", new Object[0]);
    }

    public static final /* synthetic */ String access$buildImageText(InsertImageAction $this, MarkdownImageData imageData) {
        return $this.buildImageText(imageData);
    }
}

