/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefScrollbarsHelper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\u0004*\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewLAFThemeStyles;", "", "()V", "createStylesheet", "", "obtainColorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "contrast", "Ljava/awt/Color;", "coefficient", "", "webRgba", "alpha", "intellij.markdown.core"})
public final class PreviewLAFThemeStyles {
    @NotNull
    public static final PreviewLAFThemeStyles INSTANCE = new PreviewLAFThemeStyles();

    private PreviewLAFThemeStyles() {
    }

    @JvmStatic
    @NotNull
    public static final String createStylesheet() {
        EditorColorsScheme scheme = INSTANCE.obtainColorsScheme();
        Color color = scheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"scheme.defaultForeground");
        Color contrastedForeground = INSTANCE.contrast(color, 0.1);
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground()");
        Color panelBackground = color2;
        Color color3 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"ENABLED");
        Color linkActiveForeground = color3;
        JBColor jBColor = JBColor.namedColor((String)"Group.separatorColor", (Color)panelBackground);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(\"Group.separa\u2026rColor\", panelBackground)");
        String separatorColor = PreviewLAFThemeStyles.webRgba$default(INSTANCE, (Color)jBColor, 0.0, 1, null);
        JBColor jBColor2 = JBColor.namedColor((String)"Component.infoForeground", (Color)contrastedForeground);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(\"Component.in\u2026d\", contrastedForeground)");
        String infoForeground = PreviewLAFThemeStyles.webRgba$default(INSTANCE, (Color)jBColor2, 0.0, 1, null);
        JBColor markdownFenceBackground = new JBColor(new Color(212, 222, 231, 63), new Color(212, 222, 231, 25));
        int fontSize = JBCefApp.normalizeScaledSize((int)(EditorUtil.getEditorFont().getSize() + 1));
        Color color4 = scheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"scheme.defaultBackground");
        String backgroundColor = PreviewLAFThemeStyles.webRgba$default(INSTANCE, color4, 0.0, 1, null);
        Color color5 = scheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"scheme.defaultForeground");
        return StringsKt.trimIndent((String)("\n    body {\n        background-color: " + backgroundColor + ";\n        font-size: " + fontSize + "px !important;\n    }\n    \n    body, p, blockquote, ul, ol, dl, table, pre, code, tr  {\n        color: " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, color5, 0.0, 1, null) + ";\n    }\n    \n    a {\n        color: " + PreviewLAFThemeStyles.webRgba$default(INSTANCE, linkActiveForeground, 0.0, 1, null) + ";\n    }\n    \n    table td, table th {\n      border: 1px solid " + separatorColor + ";\n    }\n    \n    hr {\n      background-color: " + separatorColor + ";\n    }\n    \n    kbd, tr {\n      border: 1px solid " + separatorColor + ";\n    }\n    \n    h6 {\n        color: " + infoForeground + ";\n    }\n    \n    blockquote {\n      border-left: 2px solid " + INSTANCE.webRgba(linkActiveForeground, 0.4) + ";\n    }\n    \n    blockquote, code, pre {\n      background-color: " + INSTANCE.webRgba((Color)markdownFenceBackground, (double)markdownFenceBackground.getAlpha() / 255.0) + ";\n    }\n    \n    " + JBCefScrollbarsHelper.buildScrollbarsStyle() + "\n    \n    "));
    }

    private final EditorColorsScheme obtainColorsScheme() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNull((Object)editorColorsManager, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl");
        EditorColorsManagerImpl manager = (EditorColorsManagerImpl)editorColorsManager;
        EditorColorsScheme activeScheme = (EditorColorsScheme)manager.getSchemeManager().getActiveScheme();
        if (activeScheme != null) {
            return activeScheme;
        }
        DefaultColorsScheme defaultColorsScheme = DefaultColorSchemesManager.getInstance().getFirstScheme();
        Intrinsics.checkNotNullExpressionValue((Object)defaultColorsScheme, (String)"getInstance().firstScheme");
        return (EditorColorsScheme)defaultColorsScheme;
    }

    private final String webRgba(Color $this$webRgba, double alpha) {
        return "rgba(" + $this$webRgba.getRed() + ", " + $this$webRgba.getGreen() + ", " + $this$webRgba.getBlue() + ", " + alpha + ")";
    }

    static /* synthetic */ String webRgba$default(PreviewLAFThemeStyles previewLAFThemeStyles, Color color, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = color.getAlpha();
        }
        return previewLAFThemeStyles.webRgba(color, d);
    }

    private final Color contrast(Color $this$contrast, double coefficient) {
        return new Color((int)(coefficient * (double)($this$contrast.getRed() - 128) + (double)128), (int)(coefficient * (double)($this$contrast.getGreen() - 128) + (double)128), (int)(coefficient * (double)($this$contrast.getBlue() - 128) + (double)128), $this$contrast.getAlpha());
    }
}

