/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.hash;

import com.google.common.hash.HashCode;
import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.java.hash.SharedIndexArchiveFileHashStore;
import com.intellij.indexing.shared.java.hash.SharedIndexJarArchiveHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/indexing/shared/java/hash/SharedIndexJarArchiveHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "()V", "hasher", "Lcom/intellij/indexing/shared/java/hash/SharedIndexArchiveFileHashStore;", "info", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "getInfo", "()Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "computeHash", "", "content", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nSharedIndexJarArchiveHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexJarArchiveHash.kt\ncom/intellij/indexing/shared/java/hash/SharedIndexJarArchiveHashProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,95:1\n43#2,3:96\n*S KotlinDebug\n*F\n+ 1 SharedIndexJarArchiveHash.kt\ncom/intellij/indexing/shared/java/hash/SharedIndexJarArchiveHashProvider\n*L\n29#1:96,3\n*E\n"})
public final class SharedIndexJarArchiveHashProvider
implements SharedIndexContentHashProvider {
    @NotNull
    private final SharedIndexArchiveFileHashStore hasher;

    public SharedIndexJarArchiveHashProvider() {
        boolean $i$f$service = false;
        Class<SharedIndexArchiveFileHashStore> serviceClass$iv = SharedIndexArchiveFileHashStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.hasher = (SharedIndexArchiveFileHashStore)object;
    }

    @Override
    @NotNull
    public SharedIndexContentHash getInfo() {
        return SharedIndexJarArchiveHash.INSTANCE;
    }

    @Override
    @Nullable
    public byte[] computeHash(@NotNull IndexedFile content) {
        HashCode hashCode;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"content.file");
        VirtualFile file = virtualFile;
        VirtualFileSystem virtualFileSystem = file.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"file.fileSystem");
        VirtualFileSystem fileSystem = virtualFileSystem;
        HashCode hash = null;
        String relPath = null;
        if (fileSystem instanceof JarFileSystem) {
            VirtualFile virtualFile2 = ((JarFileSystem)fileSystem).getRootByEntry(file);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile archiveRoot = virtualFile2;
            String string = VfsUtil.getRelativeLocation((VirtualFile)file, (VirtualFile)archiveRoot);
            if (string == null) {
                return null;
            }
            relPath = string;
            VirtualFile virtualFile3 = ((JarFileSystem)fileSystem).getLocalByEntry(file);
            if (virtualFile3 == null) {
                return null;
            }
            VirtualFile localEntry = virtualFile3;
            if (localEntry.isDirectory()) {
                return null;
            }
            hashCode = (HashCode)this.hasher.getOrComputeValue(localEntry);
            if (hashCode == null) {
                return null;
            }
        } else {
            return null;
        }
        hash = hashCode;
        byte[] byArray = hash.asBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hash.asBytes()");
        String string = relPath;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] input = ArraysKt.plus((byte[])byArray, (byte[])byArray2);
        return IndexedHashesSupport.calculateIndexedHash((IndexedFile)content, (byte[])input);
    }
}

