/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.client.common.DrawEvent;
import org.jetbrains.projector.client.common.FlushSurface;
import org.jetbrains.projector.client.common.Renderer;
import org.jetbrains.projector.client.common.StateAndPaint;
import org.jetbrains.projector.client.common.canvas.Canvas;
import org.jetbrains.projector.client.common.canvas.buffering.RenderingSurface;
import org.jetbrains.projector.client.common.misc.ImageCacher;
import org.jetbrains.projector.client.common.misc.ParamsProvider;
import org.jetbrains.projector.common.misc.Do;
import org.jetbrains.projector.common.protocol.data.ImageEventInfo;
import org.jetbrains.projector.common.protocol.data.PaintValue;
import org.jetbrains.projector.common.protocol.toClient.Flush;
import org.jetbrains.projector.common.protocol.toClient.ServerCopyAreaEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawImageEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawLineEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawPolylineEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawStringEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintOvalEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintPathEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintPolygonEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintRectEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintRoundRectEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetClipEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetCompositeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetFontEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetPaintEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetStrokeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetTransformEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowPaintEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowStateEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowToDoPaintEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowToDoStateEvent;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;", "", "renderingSurface", "Lorg/jetbrains/projector/client/common/canvas/buffering/RenderingSurface;", "imageCacher", "Lorg/jetbrains/projector/client/common/misc/ImageCacher;", "(Lorg/jetbrains/projector/client/common/canvas/buffering/RenderingSurface;Lorg/jetbrains/projector/client/common/misc/ImageCacher;)V", "renderer", "Lorg/jetbrains/projector/client/common/Renderer;", "stateSaver", "Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor$StateSaver;", "getStateSaver", "()Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor$StateSaver;", "handleDrawEvent", "", "command", "Lorg/jetbrains/projector/client/common/DrawEvent;", "processNew", "", "drawEvents", "", "(Ljava/lang/Iterable;)Ljava/lang/Integer;", "Companion", "StateSaver", "projector-client-common"})
public final class SingleRenderingSurfaceProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderingSurface renderingSurface;
    @NotNull
    private final ImageCacher imageCacher;
    @NotNull
    private final Renderer renderer;
    @NotNull
    private final StateSaver stateSaver;
    @NotNull
    private static final Logger logger;
    private static final boolean HANDLING_SUCCEED = true;
    private static final boolean HANDLING_FAILED = false;

    public SingleRenderingSurfaceProcessor(@NotNull RenderingSurface renderingSurface, @NotNull ImageCacher imageCacher) {
        Intrinsics.checkNotNullParameter((Object)renderingSurface, (String)"renderingSurface");
        Intrinsics.checkNotNullParameter((Object)imageCacher, (String)"imageCacher");
        this.renderingSurface = renderingSurface;
        this.imageCacher = imageCacher;
        this.renderer = new Renderer(this.renderingSurface);
        this.stateSaver = new StateSaver(this.renderer, this.renderingSurface);
    }

    @NotNull
    public final StateSaver getStateSaver() {
        return this.stateSaver;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Integer processNew(@NotNull Iterable<? extends DrawEvent> drawEvents) {
        Intrinsics.checkNotNullParameter(drawEvents, (String)"drawEvents");
        Integer firstUnsuccessful = null;
        Iterable<? extends DrawEvent> $this$forEachIndexed$iv = drawEvents;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (DrawEvent drawEvent : $this$forEachIndexed$iv) {
            void drawEvent2;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DrawEvent drawEvent22 = drawEvent;
            int index = n;
            boolean bl = false;
            boolean drawIsSuccessful = this.handleDrawEvent((DrawEvent)drawEvent2);
            if (drawIsSuccessful || firstUnsuccessful != null) continue;
            this.getStateSaver().saveIfNeeded();
            firstUnsuccessful = index;
        }
        return firstUnsuccessful;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleDrawEvent(DrawEvent command) {
        boolean bl;
        DrawEvent drawEvent = command;
        if (drawEvent instanceof FlushSurface) {
            this.renderingSurface.flush();
            bl = true;
        } else if (drawEvent instanceof StateAndPaint) {
            void var3_4;
            PaintValue paintValue;
            ServerWindowStateEvent it;
            Iterable $this$forEach$iv = ((StateAndPaint)command).getPrerequisites();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ServerWindowStateEvent)element$iv;
                boolean bl2 = false;
                Do do_ = Do.INSTANCE;
                ServerWindowStateEvent serverWindowStateEvent = it;
                if (serverWindowStateEvent instanceof ServerSetCompositeEvent) {
                    this.renderer.setComposite(((ServerSetCompositeEvent)it).getComposite());
                } else if (serverWindowStateEvent instanceof ServerSetPaintEvent) {
                    paintValue = ((ServerSetPaintEvent)it).getPaint();
                    boolean bl3 = false;
                    PaintValue paintValue2 = paintValue;
                    if (paintValue2 instanceof PaintValue.Color) {
                        this.renderer.setColor(((PaintValue.Color)paintValue).getArgb());
                    } else if (paintValue2 instanceof PaintValue.Gradient) {
                        this.renderer.setGradientPaint(((PaintValue.Gradient)paintValue).getP1(), ((PaintValue.Gradient)paintValue).getP2(), ((PaintValue.Gradient)paintValue).getFractions(), ((PaintValue.Gradient)paintValue).getArgbs());
                    } else if (paintValue2 instanceof PaintValue.Unknown) {
                        SingleRenderingSurfaceProcessor.Companion.logUnsupportedCommand((ServerWindowEvent)it);
                    }
                } else if (serverWindowStateEvent instanceof ServerSetClipEvent) {
                    this.renderer.setClip(((ServerSetClipEvent)it).getShape());
                } else if (serverWindowStateEvent instanceof ServerSetFontEvent) {
                    this.renderer.setFont(((ServerSetFontEvent)it).getFontId(), ((ServerSetFontEvent)it).getFontSize(), ((ServerSetFontEvent)it).getLigaturesOn());
                } else if (serverWindowStateEvent instanceof ServerSetStrokeEvent) {
                    this.renderer.setStroke(((ServerSetStrokeEvent)it).getStrokeData());
                } else if (serverWindowStateEvent instanceof ServerSetTransformEvent) {
                    this.renderer.setTransform(((ServerSetTransformEvent)it).getTx());
                } else if (serverWindowStateEvent instanceof ServerWindowToDoStateEvent) {
                    SingleRenderingSurfaceProcessor.Companion.logUnsupportedCommand((ServerWindowEvent)it);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                serverWindowStateEvent = Unit.INSTANCE;
                boolean $i$f$exhaustive = false;
            }
            boolean handlingResult = false;
            handlingResult = true;
            ServerWindowPaintEvent $this$handleDrawEvent_u24lambda_u2d3 = ((StateAndPaint)command).getPaintEvent();
            boolean bl4 = false;
            it = Do.INSTANCE;
            ServerWindowPaintEvent bl2 = $this$handleDrawEvent_u24lambda_u2d3;
            if (bl2 instanceof ServerDrawLineEvent) {
                this.renderer.drawLine(((ServerDrawLineEvent)$this$handleDrawEvent_u24lambda_u2d3).getX1(), ((ServerDrawLineEvent)$this$handleDrawEvent_u24lambda_u2d3).getY1(), ((ServerDrawLineEvent)$this$handleDrawEvent_u24lambda_u2d3).getX2(), ((ServerDrawLineEvent)$this$handleDrawEvent_u24lambda_u2d3).getY2());
            } else if (bl2 instanceof ServerDrawStringEvent) {
                this.renderer.drawString(((ServerDrawStringEvent)$this$handleDrawEvent_u24lambda_u2d3).getStr(), ((ServerDrawStringEvent)$this$handleDrawEvent_u24lambda_u2d3).getX(), ((ServerDrawStringEvent)$this$handleDrawEvent_u24lambda_u2d3).getY(), ((ServerDrawStringEvent)$this$handleDrawEvent_u24lambda_u2d3).getDesiredWidth());
            } else if (bl2 instanceof ServerPaintRectEvent) {
                this.renderer.paintRect(((ServerPaintRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getPaintType(), ((ServerPaintRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getX(), ((ServerPaintRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getY(), ((ServerPaintRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getWidth(), ((ServerPaintRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getHeight());
            } else if (bl2 instanceof ServerPaintRoundRectEvent) {
                this.renderer.paintRoundRect(((ServerPaintRoundRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getPaintType(), ((ServerPaintRoundRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getX(), ((ServerPaintRoundRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getY(), ((ServerPaintRoundRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getWidth(), ((ServerPaintRoundRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getHeight(), ((ServerPaintRoundRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getArcWidth(), ((ServerPaintRoundRectEvent)$this$handleDrawEvent_u24lambda_u2d3).getArcHeight());
            } else if (bl2 instanceof ServerDrawImageEvent) {
                Canvas.ImageSource image = this.imageCacher.getImageData(((ServerDrawImageEvent)$this$handleDrawEvent_u24lambda_u2d3).getImageId());
                if (image == null) {
                    handlingResult = false;
                } else {
                    ImageEventInfo info = ((ServerDrawImageEvent)$this$handleDrawEvent_u24lambda_u2d3).getImageEventInfo();
                    Do $i$f$exhaustive = Do.INSTANCE;
                    paintValue = info;
                    if (paintValue instanceof ImageEventInfo.Ds) {
                        int dw = ((ImageEventInfo.Ds)info).getDx2() - ((ImageEventInfo.Ds)info).getDx1();
                        int dh = ((ImageEventInfo.Ds)info).getDy2() - ((ImageEventInfo.Ds)info).getDy1();
                        int sw = ((ImageEventInfo.Ds)info).getSx2() - ((ImageEventInfo.Ds)info).getSx1();
                        int sh = ((ImageEventInfo.Ds)info).getSy2() - ((ImageEventInfo.Ds)info).getSy1();
                        Renderer renderer = this.renderer;
                        double d = ((ImageEventInfo.Ds)info).getDx1();
                        double d2 = ((ImageEventInfo.Ds)info).getDy1();
                        double d3 = dw;
                        double d4 = dh;
                        double d5 = ((ImageEventInfo.Ds)info).getSx1();
                        double d6 = ((ImageEventInfo.Ds)info).getSy1();
                        double d7 = sw;
                        double d8 = sh;
                        renderer.drawImage(image, d5, d6, d7, d8, d, d2, d3, d4);
                    } else if (paintValue instanceof ImageEventInfo.Xy) {
                        this.renderer.drawImage(image, ((ImageEventInfo.Xy)info).getX(), ((ImageEventInfo.Xy)info).getY());
                    } else if (paintValue instanceof ImageEventInfo.XyWh) {
                        this.renderer.drawImage(image, ((ImageEventInfo.XyWh)info).getX(), ((ImageEventInfo.XyWh)info).getY(), ((ImageEventInfo.XyWh)info).getWidth(), ((ImageEventInfo.XyWh)info).getHeight());
                    } else if (paintValue instanceof ImageEventInfo.Transformed) {
                        this.renderer.drawImage(image, ((ImageEventInfo.Transformed)info).getTx());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    paintValue = Unit.INSTANCE;
                    boolean $i$f$exhaustive2 = false;
                }
            } else if (bl2 instanceof ServerPaintPathEvent) {
                this.renderer.paintPath(((ServerPaintPathEvent)$this$handleDrawEvent_u24lambda_u2d3).getPaintType(), ((ServerPaintPathEvent)$this$handleDrawEvent_u24lambda_u2d3).getPath());
            } else if (bl2 instanceof ServerPaintOvalEvent) {
                this.renderer.paintOval(((ServerPaintOvalEvent)$this$handleDrawEvent_u24lambda_u2d3).getPaintType(), ((ServerPaintOvalEvent)$this$handleDrawEvent_u24lambda_u2d3).getX(), ((ServerPaintOvalEvent)$this$handleDrawEvent_u24lambda_u2d3).getY(), ((ServerPaintOvalEvent)$this$handleDrawEvent_u24lambda_u2d3).getWidth(), ((ServerPaintOvalEvent)$this$handleDrawEvent_u24lambda_u2d3).getHeight());
            } else if (bl2 instanceof ServerPaintPolygonEvent) {
                this.renderer.paintPolygon(((ServerPaintPolygonEvent)$this$handleDrawEvent_u24lambda_u2d3).getPaintType(), ((ServerPaintPolygonEvent)$this$handleDrawEvent_u24lambda_u2d3).getPoints());
            } else if (bl2 instanceof ServerDrawPolylineEvent) {
                this.renderer.drawPolyline(((ServerDrawPolylineEvent)$this$handleDrawEvent_u24lambda_u2d3).getPoints());
            } else if (bl2 instanceof ServerCopyAreaEvent) {
                this.renderer.copyArea(((ServerCopyAreaEvent)$this$handleDrawEvent_u24lambda_u2d3).getX(), ((ServerCopyAreaEvent)$this$handleDrawEvent_u24lambda_u2d3).getY(), ((ServerCopyAreaEvent)$this$handleDrawEvent_u24lambda_u2d3).getWidth(), ((ServerCopyAreaEvent)$this$handleDrawEvent_u24lambda_u2d3).getHeight(), ((ServerCopyAreaEvent)$this$handleDrawEvent_u24lambda_u2d3).getDx(), ((ServerCopyAreaEvent)$this$handleDrawEvent_u24lambda_u2d3).getDy());
            } else if (bl2 instanceof ServerWindowToDoPaintEvent) {
                SingleRenderingSurfaceProcessor.Companion.logUnsupportedCommand((ServerWindowEvent)$this$handleDrawEvent_u24lambda_u2d3);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            bl2 = Unit.INSTANCE;
            boolean $i$f$exhaustive = false;
            bl = var3_4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(SingleRenderingSurfaceProcessor.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor$StateSaver;", "", "renderer", "Lorg/jetbrains/projector/client/common/Renderer;", "renderingSurface", "Lorg/jetbrains/projector/client/common/canvas/buffering/RenderingSurface;", "(Lorg/jetbrains/projector/client/common/Renderer;Lorg/jetbrains/projector/client/common/canvas/buffering/RenderingSurface;)V", "lastSuccessfulState", "Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor$StateSaver$LastSuccessfulState;", "restoreIfNeeded", "", "saveIfNeeded", "LastSuccessfulState", "projector-client-common"})
    public static final class StateSaver {
        @NotNull
        private final Renderer renderer;
        @NotNull
        private final RenderingSurface renderingSurface;
        @Nullable
        private LastSuccessfulState lastSuccessfulState;

        public StateSaver(@NotNull Renderer renderer, @NotNull RenderingSurface renderingSurface) {
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            Intrinsics.checkNotNullParameter((Object)renderingSurface, (String)"renderingSurface");
            this.renderer = renderer;
            this.renderingSurface = renderingSurface;
        }

        public final void saveIfNeeded() {
            if (this.lastSuccessfulState != null) {
                return;
            }
            this.lastSuccessfulState = new LastSuccessfulState(Renderer.Companion.RequestedRenderingState.copy$default(this.renderer.getRequestedState(), null, null, null, null, null, 0.0, null, 127, null), this.renderingSurface.getCanvas().takeSnapshot());
        }

        public final void restoreIfNeeded() {
            LastSuccessfulState lastSuccessfulState = this.lastSuccessfulState;
            if (lastSuccessfulState != null) {
                LastSuccessfulState it = lastSuccessfulState;
                boolean bl = false;
                this.renderer.drawImageRaw(it.getImage());
                this.renderer.getRequestedState().setTo(it.getRenderingState());
                this.lastSuccessfulState = null;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor$StateSaver$LastSuccessfulState;", "", "renderingState", "Lorg/jetbrains/projector/client/common/Renderer$Companion$RequestedRenderingState;", "image", "Lorg/jetbrains/projector/client/common/canvas/Canvas$Snapshot;", "(Lorg/jetbrains/projector/client/common/Renderer$Companion$RequestedRenderingState;Lorg/jetbrains/projector/client/common/canvas/Canvas$Snapshot;)V", "getImage", "()Lorg/jetbrains/projector/client/common/canvas/Canvas$Snapshot;", "getRenderingState", "()Lorg/jetbrains/projector/client/common/Renderer$Companion$RequestedRenderingState;", "projector-client-common"})
        private static final class LastSuccessfulState {
            @NotNull
            private final Renderer.Companion.RequestedRenderingState renderingState;
            @NotNull
            private final Canvas.Snapshot image;

            public LastSuccessfulState(@NotNull Renderer.Companion.RequestedRenderingState renderingState, @NotNull Canvas.Snapshot image) {
                Intrinsics.checkNotNullParameter((Object)renderingState, (String)"renderingState");
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                this.renderingState = renderingState;
                this.image = image;
            }

            @NotNull
            public final Renderer.Companion.RequestedRenderingState getRenderingState() {
                return this.renderingState;
            }

            @NotNull
            public final Canvas.Snapshot getImage() {
                return this.image;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000b0\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor$Companion;", "", "()V", "HANDLING_FAILED", "", "HANDLING_SUCCEED", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "logUnsupportedCommand", "", "command", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowEvent;", "shrinkByPaintEvents", "", "Lorg/jetbrains/projector/client/common/DrawEvent;", "projector-client-common"})
    public static final class Companion {
        private Companion() {
        }

        private final void logUnsupportedCommand(ServerWindowEvent command) {
            if (ParamsProvider.INSTANCE.getLOG_UNSUPPORTED_EVENTS()) {
                Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(command){
                    final /* synthetic */ ServerWindowEvent $command;
                    {
                        this.$command = $command;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Unsupported: " + this.$command;
                    }
                }), (int)1, null);
            }
        }

        @NotNull
        public final List<DrawEvent> shrinkByPaintEvents(@NotNull List<? extends ServerWindowEvent> $this$shrinkByPaintEvents) {
            Intrinsics.checkNotNullParameter($this$shrinkByPaintEvents, (String)"<this>");
            List result = new ArrayList();
            Ref.ObjectRef prerequisites = new Ref.ObjectRef();
            prerequisites.element = new ArrayList();
            Iterable $this$forEach$iv = $this$shrinkByPaintEvents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Boolean bl;
                ServerWindowEvent it = (ServerWindowEvent)element$iv;
                boolean bl2 = false;
                Do do_ = Do.INSTANCE;
                Object object = it;
                if (object instanceof ServerWindowStateEvent) {
                    bl = ((List)prerequisites.element).add(it);
                } else if (object instanceof ServerWindowPaintEvent) {
                    result.add(new StateAndPaint((List)prerequisites.element, (ServerWindowPaintEvent)it));
                    prerequisites.element = new ArrayList();
                    bl = Unit.INSTANCE;
                } else if (object instanceof Flush) {
                    bl = result.add(FlushSurface.INSTANCE);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object = bl;
                boolean $i$f$exhaustive = false;
            }
            if (!((Collection)prerequisites.element).isEmpty()) {
                Logger.DefaultImpls.error$default((Logger)logger, null, (Function0)((Function0)new Function0<String>((Ref.ObjectRef<List<ServerWindowStateEvent>>)prerequisites){
                    final /* synthetic */ Ref.ObjectRef<List<ServerWindowStateEvent>> $prerequisites;
                    {
                        this.$prerequisites = $prerequisites;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Bad commands received from server: " + ((List)this.$prerequisites.element).size() + " state events are at the end";
                    }
                }), (int)1, null);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

