/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u001e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a.\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010\u001a6\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u001aL\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u000e\b\u0006\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0086\b\u00f8\u0001\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"notebookAppearance", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookEditorAppearance;", "Lcom/intellij/openapi/editor/Editor;", "getNotebookAppearance", "(Lcom/intellij/openapi/editor/Editor;)Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookEditorAppearance;", "installNotebookEditorView", "", "editor", "paintCaretRow", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "lines", "Lkotlin/ranges/IntRange;", "paintCellGutter", "inlayBounds", "Ljava/awt/Rectangle;", "r", "paintCellStripe", "appearance", "stripe", "Ljava/awt/Color;", "top", "", "height", "paintNotebookCellBackgroundGutter", "actionBetweenBackgroundAndStripe", "Lkotlin/Function0;", "intellij.notebooks.ui"})
public final class NotebookUtilKt {
    @NotNull
    public static final NotebookEditorAppearance getNotebookAppearance(@NotNull Editor $this$notebookAppearance) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookAppearance, (String)"<this>");
        Object object = NotebookEditorAppearance.Companion.getNOTEBOOK_APPEARANCE_KEY().get((UserDataHolder)$this$notebookAppearance);
        Intrinsics.checkNotNull((Object)object);
        return (NotebookEditorAppearance)object;
    }

    public static final void paintNotebookCellBackgroundGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull IntRange lines, int top, int height, @NotNull Function0<Unit> actionBetweenBackgroundAndStripe) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter(actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        NotebookEditorAppearance appearance = NotebookUtilKt.getNotebookAppearance((Editor)editor);
        Color stripe = appearance.getCellStripeColor(editor, lines);
        Color stripeHover = appearance.getCellStripeHoverColor(editor, lines);
        int borderWidth = appearance.getLeftBorderWidth();
        int rectBorderCellX = r.width - borderWidth;
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        g.setColor(appearance.getCodeCellBackground(editorColorsScheme));
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(rectBorderCellX + 3, top, borderWidth - 3, height);
        } else {
            g.fillRect(rectBorderCellX, top, borderWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        if (stripe != null) {
            NotebookUtilKt.paintCellStripe(appearance, g, r, stripe, top, height);
        }
        if (stripeHover != null) {
            g.setColor(stripeHover);
            g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineHoverWidth(), height);
        }
    }

    public static /* synthetic */ void paintNotebookCellBackgroundGutter$default(EditorImpl editor, Graphics g, Rectangle r, IntRange lines, int top, int height, Function0 actionBetweenBackgroundAndStripe, int n, Object object) {
        if ((n & 0x40) != 0) {
            actionBetweenBackgroundAndStripe = paintNotebookCellBackgroundGutter.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        NotebookEditorAppearance appearance = NotebookUtilKt.getNotebookAppearance((Editor)editor);
        Color stripe = appearance.getCellStripeColor(editor, lines);
        Color stripeHover = appearance.getCellStripeHoverColor(editor, lines);
        int borderWidth = appearance.getLeftBorderWidth();
        int rectBorderCellX = r.width - borderWidth;
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        g.setColor(appearance.getCodeCellBackground(editorColorsScheme));
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(rectBorderCellX + 3, top, borderWidth - 3, height);
        } else {
            g.fillRect(rectBorderCellX, top, borderWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        if (stripe != null) {
            NotebookUtilKt.paintCellStripe(appearance, g, r, stripe, top, height);
        }
        if (stripeHover != null) {
            g.setColor(stripeHover);
            g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineHoverWidth(), height);
        }
    }

    public static final void paintCellStripe(@NotNull NotebookEditorAppearance appearance, @NotNull Graphics g, @NotNull Rectangle r, @NotNull Color stripe, int top, int height) {
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)stripe, (String)"stripe");
        g.setColor(stripe);
        g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineWidth(), height);
    }

    public static final void paintCellGutter(@NotNull Rectangle inlayBounds, @NotNull IntRange lines, @NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)inlayBounds, (String)"inlayBounds");
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            NotebookEditorAppearance appearance = NotebookUtilKt.getNotebookAppearance((Editor)editor);
            Color color = appearance.getCellStripeColor(editor, lines);
            if (color == null) break block0;
            Color stripeColor = color;
            boolean bl = false;
            NotebookUtilKt.paintCellStripe(appearance, g, r, stripeColor, inlayBounds.y, inlayBounds.height);
        }
    }

    public static final void paintCaretRow(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        if (editor.getSettings().isCaretRowShown()) {
            CaretModelImpl caretModelImpl = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModelImpl, (String)"editor.caretModel");
            CaretModelImpl caretModel = caretModelImpl;
            int caretLine = caretModel.getLogicalPosition().line;
            int n = lines.getFirst();
            boolean bl = caretLine <= lines.getLast() ? n <= caretLine : false;
            if (bl) {
                g.setColor(editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
                g.fillRect(0, editor.visualLineToY(caretModel.getVisualPosition().line), g.getClipBounds().width, editor.getLineHeight());
            }
        }
    }

    public static final void installNotebookEditorView(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).getGutterComponentEx().setLineNumberConverter(new LineNumberConverter(){

                @Nullable
                public Integer convert(@NotNull Editor editor, int lineNumber) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    return null;
                }

                @Nullable
                public Integer getMaxLineNumber(@NotNull Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    return null;
                }
            });
        }
    }
}

