/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.CellBorderComponentsKt;
import org.jetbrains.plugins.notebooks.ui.visualization.JupyterCellBorderButton;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.ui.visualization.SausageBorder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/SausageButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "installUI", "", "c", "Ljavax/swing/JComponent;", "update", "g", "Ljava/awt/Graphics;", "intellij.notebooks.ui"})
final class SausageButtonUI
extends BasicButtonUI {
    @NotNull
    private final Editor editor;

    public SausageButtonUI(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @Override
    public void update(@NotNull Graphics g, @NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        JupyterCellBorderButton cfr_ignored_0 = (JupyterCellBorderButton)c;
        JupyterCellBorderButton jupyterCellBorderButton = (JupyterCellBorderButton)c;
        NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance(this.editor);
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        jupyterCellBorderButton.setBackground(notebookEditorAppearance.getSausageButtonAppearanceBackgroundColor(editorColorsScheme));
        JupyterCellBorderButton jupyterCellBorderButton2 = (JupyterCellBorderButton)c;
        NotebookEditorAppearance notebookEditorAppearance2 = NotebookUtilKt.getNotebookAppearance(this.editor);
        EditorColorsScheme editorColorsScheme2 = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"editor.colorsScheme");
        jupyterCellBorderButton2.setForeground(notebookEditorAppearance2.getSausageButtonAppearanceForegroundColor(editorColorsScheme2));
        g.setColor(((JupyterCellBorderButton)c).getBackground());
        int x = 0;
        int y = 0;
        int width = ((JupyterCellBorderButton)c).getWidth();
        int height = ((JupyterCellBorderButton)c).getHeight();
        Container container = ((JupyterCellBorderButton)c).getParent();
        Component[] components = container != null ? container.getComponents() : null;
        JButton leftButton = CellBorderComponentsKt.access$getLeftButton(components);
        JButton rightButton = CellBorderComponentsKt.access$getRightButton(components);
        int radius = height / 2;
        if (components == null || components.length <= 1) {
            g.fillRoundRect(x, y, width, height, height, height);
        } else if (leftButton == c) {
            g.fillRect(x + radius, y, width, height);
            g.fillArc(x, y, height, height, 90, 180);
        } else if (rightButton == c) {
            g.fillRect(x, y, width - radius, height);
            g.fillArc(x + width - height, y, height, height, -90, 180);
        } else {
            g.fillRect(x, y, width, height);
        }
        this.paint(g, c);
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        c.setBorder(new SausageBorder(this.editor));
        c.setCursor(Cursor.getPredefinedCursor(12));
        c.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        super.installUI(c);
    }
}

