/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui;

import com.intellij.ui.Gray;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.TableFilterHeader;

class PositionHelper
implements PropertyChangeListener {
    TableFilterHeader.Position location;
    JViewport headerViewport;
    Component previousTableViewport;
    TableFilterHeader filterHeader;

    public PositionHelper(TableFilterHeader filterHeader) {
        this.filterHeader = filterHeader;
    }

    public void setPosition(TableFilterHeader.Position location) {
        this.location = location;
        JTable table = this.filterHeader.getTable();
        this.changeTable(table, table);
    }

    public TableFilterHeader.Position getPosition() {
        return this.location;
    }

    public void headerVisibilityChanged(boolean visible) {
        JTable table = this.filterHeader.getTable();
        this.changeTable(table, null);
        if (visible && table != null) {
            this.changeTable(null, table);
        }
    }

    public void changeTable(JTable oldTable, JTable newTable) {
        if (oldTable != null) {
            oldTable.removePropertyChangeListener("ancestor", this);
        }
        this.cleanUp();
        if (newTable != null) {
            newTable.addPropertyChangeListener("ancestor", this);
            this.trySetUp(newTable);
        }
    }

    public void filterHeaderContainmentUpdate() {
        if (!this.canHeaderLocationBeManaged()) {
            this.cleanUp();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.previousTableViewport != evt.getNewValue() || evt.getSource() != this.filterHeader.getTable()) {
            this.previousTableViewport = null;
            this.cleanUp();
            this.trySetUp(this.filterHeader.getTable());
        }
    }

    private boolean canHeaderLocationBeManaged() {
        if (this.location == TableFilterHeader.Position.NONE) {
            return false;
        }
        Container parent = this.filterHeader.getParent();
        return parent == null || parent == this.headerViewport;
    }

    private void trySetUp(JTable table) {
        JScrollPane scrollPane;
        JViewport viewport;
        Container gp;
        Container p;
        if (table != null && table.isVisible() && this.canHeaderLocationBeManaged() && this.filterHeader.isVisible() && (p = table.getParent()) instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && (viewport = (scrollPane = (JScrollPane)gp).getViewport()) != null && viewport.getView() == table) {
            this.setUp(scrollPane);
            this.previousTableViewport = p;
        }
    }

    private void setUp(JScrollPane scrollPane) {
        Component view;
        this.headerViewport = new JViewport(){
            private static final long serialVersionUID = 7109623726722227105L;

            @Override
            public void setView(Component view) {
                if (view instanceof JTableHeader) {
                    this.removeTableHeader();
                    view.setVisible(PositionHelper.this.location != TableFilterHeader.Position.REPLACE);
                    ((JTableHeader)view).setOpaque(false);
                    view.setBackground(Gray.TRANSPARENT);
                    PositionHelper.this.filterHeader.add(view, PositionHelper.this.location == TableFilterHeader.Position.INLINE ? "North" : "South");
                    PositionHelper.this.filterHeader.revalidate();
                    super.setView(PositionHelper.this.filterHeader);
                }
            }

            private Component removeTableHeader() {
                Component tableHeader = PositionHelper.this.getTableHeader();
                if (tableHeader != null) {
                    PositionHelper.this.filterHeader.remove(tableHeader);
                }
                return tableHeader;
            }
        };
        JViewport currentColumnHeader = scrollPane.getColumnHeader();
        if (currentColumnHeader != null && (view = currentColumnHeader.getView()) != null) {
            this.headerViewport.setView(view);
        }
        scrollPane.setColumnHeader(this.headerViewport);
    }

    private void cleanUp() {
        JViewport currentViewport = this.headerViewport;
        this.headerViewport = null;
        if (currentViewport != null) {
            JScrollPane scrollPane;
            currentViewport.remove(this.filterHeader);
            Container parent = currentViewport.getParent();
            if (parent instanceof JScrollPane && (scrollPane = (JScrollPane)parent).getColumnHeader() == currentViewport) {
                Component tableHeader = this.getTableHeader();
                JViewport newView = tableHeader == null ? null : this.createCleanViewport(tableHeader);
                scrollPane.setColumnHeader(newView);
            }
        }
    }

    private JViewport createCleanViewport(Component tableHeader) {
        JViewport ret = new JViewport();
        ret.setView(tableHeader);
        return ret;
    }

    Component getTableHeader() {
        for (Component component : this.filterHeader.getComponents()) {
            if (!(component instanceof JTableHeader)) continue;
            return component;
        }
        return null;
    }
}

