/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrailingSpacesInPropertyInspection
extends PropertiesInspectionBase {
    public boolean myIgnoreVisibleSpaces;

    @NotNull
    public String getShortName() {
        return "TrailingSpacesInProperty";
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            TrailingSpacesInPropertyInspection.$$$reportNull$$$0(0);
        }
        if (this.myIgnoreVisibleSpaces) {
            node.setAttribute("ignoreVisibleSpaces", Boolean.TRUE.toString());
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        String attributeValue;
        if (node == null) {
            TrailingSpacesInPropertyInspection.$$$reportNull$$$0(1);
        }
        if ((attributeValue = node.getAttributeValue("ignoreVisibleSpaces")) != null) {
            this.myIgnoreVisibleSpaces = Boolean.parseBoolean(attributeValue);
        }
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreVisibleSpaces", (String)PropertiesBundle.message("trailing.spaces.in.property.inspection.ignore.visible.spaces", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            TrailingSpacesInPropertyInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            TrailingSpacesInPropertyInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            TrailingSpacesInPropertyInspection.$$$reportNull$$$0(4);
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        List<IProperty> properties = ((PropertiesFile)file).getProperties();
        SmartList descriptors = new SmartList();
        for (IProperty property : properties) {
            ProgressManager.checkCanceled();
            PropertyImpl propertyImpl = (PropertyImpl)property;
            for (ASTNode node : (ASTNode[])ContainerUtil.ar((Object[])new ASTNode[]{propertyImpl.getKeyNode(), propertyImpl.getValueNode()})) {
                PsiElement key;
                TextRange textRange;
                if (node == null || (textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(key = node.getPsi(), this.myIgnoreVisibleSpaces)) == null) continue;
                descriptors.add(manager.createProblemDescriptor(key, textRange, PropertiesBundle.message("inspection.trailing.spaces.in.property.trailing.spaces.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{new RemoveTrailingSpacesFix(this.myIgnoreVisibleSpaces)}));
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static TextRange getTrailingSpaces(PsiElement element, boolean ignoreVisibleTrailingSpaces) {
        String key = element.getText();
        if (ignoreVisibleTrailingSpaces) {
            for (int i = key.length() - 1; i > -1; --i) {
                if (key.charAt(i) == ' ' || key.charAt(i) == '\t') continue;
                return i == key.length() - 1 ? null : new TextRange(i + 1, key.length());
            }
            return element.getTextRange();
        }
        return PropertyImpl.trailingSpaces(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/codeInspection/TrailingSpacesInPropertyInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/codeInspection/TrailingSpacesInPropertyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class RemoveTrailingSpacesFix
    implements LocalQuickFix {
        private final boolean myIgnoreVisibleSpaces;

        private RemoveTrailingSpacesFix(boolean ignoreVisibleSpaces) {
            this.myIgnoreVisibleSpaces = ignoreVisibleSpaces;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("remove.trailing.spaces.fix.family.name", new Object[0]);
            if (string == null) {
                RemoveTrailingSpacesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                RemoveTrailingSpacesFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveTrailingSpacesFix.$$$reportNull$$$0(2);
            }
            PsiElement psiElement = parent = (element = descriptor.getPsiElement()) == null ? null : element.getParent();
            if (!(parent instanceof PropertyImpl)) {
                return;
            }
            TextRange textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(element, this.myIgnoreVisibleSpaces);
            if (textRange != null) {
                Document document = element.getContainingFile().getViewProvider().getDocument();
                TextRange docRange = textRange.shiftRight(element.getTextRange().getStartOffset());
                document.deleteString(docRange.getStartOffset(), docRange.getEndOffset());
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                RemoveTrailingSpacesFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                RemoveTrailingSpacesFix.$$$reportNull$$$0(4);
            }
            this.applyFix(project, previewDescriptor);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF_NO_TRIM;
            if (intentionPreviewInfo == null) {
                RemoveTrailingSpacesFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/codeInspection/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/codeInspection/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

