/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection.duplicatePropertyInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processors;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class DuplicatePropertyInspection
extends GlobalSimpleInspectionTool {
    public boolean CURRENT_FILE = true;
    public boolean MODULE_WITH_DEPENDENCIES = false;
    public boolean CHECK_DUPLICATE_VALUES = true;
    public boolean CHECK_DUPLICATE_KEYS = true;
    public boolean CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES = true;

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(3);
        }
        if (problemDescriptionsProcessor == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(4);
        }
        this.checkFile(file, manager, (GlobalInspectionContextBase)globalContext, globalContext.getRefManager(), problemDescriptionsProcessor);
    }

    private static void surroundWithHref(@NotNull StringBuilder anchor, PsiElement element, boolean isValue) {
        if (anchor == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(5);
        }
        if (element != null) {
            PsiElement elementToLink;
            PsiElement parent = element.getParent();
            PsiElement psiElement = elementToLink = isValue ? parent.getFirstChild() : parent.getLastChild();
            if (elementToLink != null) {
                VirtualFile virtualFile;
                HTMLComposer.appendAfterHeaderIndention((StringBuilder)anchor);
                HTMLComposer.appendAfterHeaderIndention((StringBuilder)anchor);
                Object link = "";
                PsiFile file = element.getContainingFile();
                if (file != null && (virtualFile = file.getVirtualFile()) != null) {
                    link = virtualFile.getUrl() + "#" + elementToLink.getTextRange().getStartOffset();
                }
                HtmlChunk.link((String)link, (String)elementToLink.getText().replaceAll("\\$", "\\\\\\$")).appendTo(anchor);
                DuplicatePropertyInspection.compoundLineLink(anchor, element);
                anchor.append("<br>");
            }
        } else {
            HtmlChunk.tag((String)"font").style("font-family:verdana; font-weight:bold; color:#FF0000").addText(PropertiesBundle.message("inspection.export.results.invalidated.item", new Object[0])).appendTo(anchor);
        }
    }

    private static void compoundLineLink(@NotNull StringBuilder lineAnchor, PsiElement psiElement) {
        VirtualFile vFile;
        PsiFile file;
        if (lineAnchor == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(6);
        }
        if ((file = psiElement.getContainingFile()) != null && (vFile = file.getVirtualFile()) != null) {
            Document doc = FileDocumentManager.getInstance().getDocument(vFile);
            int lineNumber = doc.getLineNumber(psiElement.getTextOffset()) + 1;
            lineAnchor.append(" ").append(AnalysisBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0])).append(" ");
            int offset = doc.getLineStartOffset(lineNumber - 1);
            offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)offset, (String)" \t");
            HtmlChunk.link((String)(vFile.getUrl() + "#" + offset), (String)String.valueOf(lineNumber)).appendTo(lineAnchor);
        }
    }

    private void checkFile(PsiFile file, InspectionManager manager, GlobalInspectionContextBase context, RefManager refManager, ProblemDescriptionsProcessor processor) {
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        if (!context.isToCheckFile(file, (InspectionProfileEntry)this) || SuppressionUtil.inspectionResultSuppressed((PsiElement)file, (InspectionProfileEntry)this)) {
            return;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)file.getProject());
        List<IProperty> properties = propertiesFile.getProperties();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)(this.CURRENT_FILE ? GlobalSearchScope.fileScope((PsiFile)file) : (this.MODULE_WITH_DEPENDENCIES ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)file.getProject()))), (FileType[])new FileType[]{PropertiesFileType.INSTANCE});
        Map processedValueToFiles = Collections.synchronizedMap(new HashMap());
        Map processedKeyToFiles = Collections.synchronizedMap(new HashMap());
        ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        ProgressWrapper progress = ProgressWrapper.wrap((ProgressIndicator)original);
        ProgressManager.getInstance().runProcess(() -> this.lambda$checkFile$1(properties, (ProgressIndicator)progress, original, processedValueToFiles, processedKeyToFiles, searchHelper, scope, manager, file, processor, refManager), (ProgressIndicator)progress);
    }

    private static void processTextUsages(Map<String, Set<PsiFile>> processedTextToFiles, String text, Map<String, Set<PsiFile>> processedFoundTextToFiles, PsiSearchHelper searchHelper, GlobalSearchScope scope) {
        if (!processedTextToFiles.containsKey(text)) {
            if (processedFoundTextToFiles.containsKey(text)) {
                Set<PsiFile> filesWithValue = processedFoundTextToFiles.get(text);
                processedTextToFiles.put(text, filesWithValue);
            } else {
                HashSet resultFiles = new HashSet();
                DuplicatePropertyInspection.findFilesWithText(text, searchHelper, scope, resultFiles);
                if (resultFiles.isEmpty()) {
                    return;
                }
                processedTextToFiles.put(text, resultFiles);
            }
        }
    }

    private static void prepareDuplicateValuesByFile(Map<String, Set<PsiFile>> valueToFiles, InspectionManager manager, List<? super ProblemDescriptor> problemDescriptors, PsiFile psiFile, ProgressIndicator progress) {
        for (String value : valueToFiles.keySet()) {
            if (progress != null) {
                progress.setText2(PropertiesBundle.message("duplicate.property.value.progress.indicator.text", value));
                progress.checkCanceled();
            }
            if (value.length() == 0) continue;
            StringSearcher searcher = new StringSearcher(value, true, true);
            @Nls StringBuilder message = new StringBuilder();
            int[] duplicatesCount = new int[]{0};
            Property[] propertyInCurrentFile = new Property[1];
            Set<PsiFile> psiFilesWithDuplicates = valueToFiles.get(value);
            for (PsiFile file : psiFilesWithDuplicates) {
                CharSequence text = file.getViewProvider().getContents();
                LowLevelSearchUtil.processTexts((CharSequence)text, (int)0, (int)text.length(), (StringSearcher)searcher, offset -> {
                    Property property;
                    PsiElement patt10317$temp;
                    PsiElement element = file.findElementAt(offset);
                    if (element != null && (patt10317$temp = element.getParent()) instanceof Property && Objects.equals((property = (Property)patt10317$temp).getValue(), value) && element.getStartOffsetInParent() != 0) {
                        if (duplicatesCount[0] == 0) {
                            message.append(PropertiesBundle.message("duplicate.property.value.problem.descriptor", property.getValue()));
                        }
                        DuplicatePropertyInspection.surroundWithHref(message, element, true);
                        duplicatesCount[0] = duplicatesCount[0] + 1;
                        if (propertyInCurrentFile[0] == null && psiFile == file) {
                            propertyInCurrentFile[0] = property;
                        }
                    }
                    return true;
                });
            }
            if (duplicatesCount[0] <= 1) continue;
            PsiElement elementToHighlight = (PsiElement)ObjectUtils.notNull((Object)propertyInCurrentFile[0], (Object)psiFile);
            problemDescriptors.add((ProblemDescriptor)manager.createProblemDescriptor(elementToHighlight, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private void prepareDuplicateKeysByFile(Map<String, Set<PsiFile>> keyToFiles, InspectionManager manager, Map<String, Set<String>> keyToValues, List<? super ProblemDescriptor> problemDescriptors, PsiFile psiFile, ProgressIndicator progress) {
        for (String key : keyToFiles.keySet()) {
            if (progress != null) {
                progress.setText2(PropertiesBundle.message("duplicate.property.key.progress.indicator.text", key));
                ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)progress);
            }
            @Nls StringBuilder message = new StringBuilder();
            int duplicatesCount = 0;
            PsiElement propertyInCurrentFile = null;
            Set<PsiFile> psiFilesWithDuplicates = keyToFiles.get(key);
            for (PsiFile file : psiFilesWithDuplicates) {
                if (!(file instanceof PropertiesFile)) continue;
                PropertiesFile propertiesFile = (PropertiesFile)file;
                List<IProperty> propertiesByKey = propertiesFile.findPropertiesByKey(key);
                for (IProperty property : propertiesByKey) {
                    if (duplicatesCount == 0) {
                        message.append(PropertiesBundle.message("duplicate.property.key.problem.descriptor", key));
                    }
                    DuplicatePropertyInspection.surroundWithHref(message, property.getPsiElement().getFirstChild(), false);
                    ++duplicatesCount;
                    Set<String> values = keyToValues.get(key);
                    if (values == null) {
                        values = new HashSet<String>();
                        keyToValues.put(key, values);
                    }
                    values.add(property.getValue());
                    if (propertyInCurrentFile != null || file != psiFile) continue;
                    propertyInCurrentFile = property.getPsiElement();
                }
            }
            if (duplicatesCount <= true || !this.CHECK_DUPLICATE_KEYS) continue;
            problemDescriptors.add((ProblemDescriptor)manager.createProblemDescriptor((PsiElement)ObjectUtils.notNull(propertyInCurrentFile, (Object)psiFile), message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static void processDuplicateKeysWithDifferentValues(Map<String, Set<String>> keyToDifferentValues, Map<String, Set<PsiFile>> keyToFiles, List<? super ProblemDescriptor> problemDescriptors, InspectionManager manager, PsiFile psiFile, ProgressIndicator progress) {
        for (String key : keyToDifferentValues.keySet()) {
            Set<String> values;
            if (progress != null) {
                progress.setText2(PropertiesBundle.message("duplicate.property.diff.key.progress.indicator.text", key));
                ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)progress);
            }
            if ((values = keyToDifferentValues.get(key)) == null || values.size() < 2) {
                keyToFiles.remove(key);
                continue;
            }
            @Nls StringBuilder message = new StringBuilder();
            Set<PsiFile> psiFiles = keyToFiles.get(key);
            boolean firstUsage = true;
            for (PsiFile file : psiFiles) {
                if (!(file instanceof PropertiesFile)) continue;
                PropertiesFile propertiesFile = (PropertiesFile)file;
                List<IProperty> propertiesByKey = propertiesFile.findPropertiesByKey(key);
                for (IProperty property : propertiesByKey) {
                    if (firstUsage) {
                        message.append(PropertiesBundle.message("duplicate.property.diff.key.problem.descriptor", key));
                        firstUsage = false;
                    }
                    DuplicatePropertyInspection.surroundWithHref(message, property.getPsiElement().getFirstChild(), false);
                }
            }
            problemDescriptors.add((ProblemDescriptor)manager.createProblemDescriptor((PsiElement)psiFile, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static void findFilesWithText(String stringToFind, PsiSearchHelper searchHelper, GlobalSearchScope scope, Set<? super PsiFile> resultFiles) {
        List words = StringUtil.getWordsIn((String)stringToFind);
        if (words.isEmpty()) {
            return;
        }
        words.sort((o1, o2) -> o2.length() - o1.length());
        for (String word : words) {
            HashSet files = new HashSet();
            searchHelper.processAllFilesWithWord(word, scope, Processors.cancelableCollectProcessor(files), true);
            if (resultFiles.isEmpty()) {
                resultFiles.addAll(files);
            } else {
                resultFiles.retainAll(files);
            }
            if (!resultFiles.isEmpty()) continue;
            return;
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.properties.files", (Object[])new Object[0]);
        if (string == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DuplicatePropertyInspection";
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptDropdown scope = OptPane.dropdown((String)"SCOPE", (String)PropertiesBundle.message("label.analysis.scope", new Object[0]), (OptDropdown.Option[])new OptDropdown.Option[]{OptPane.option((String)"file", (String)PropertiesBundle.message("duplicate.property.file.scope.option", new Object[0])), OptPane.option((String)"module", (String)PropertiesBundle.message("duplicate.property.module.scope.option", new Object[0])), OptPane.option((String)"project", (String)PropertiesBundle.message("duplicate.property.project.scope.option", new Object[0]))});
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{scope, OptPane.checkbox((String)"CHECK_DUPLICATE_VALUES", (String)PropertiesBundle.message("duplicate.property.value.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES", (String)PropertiesBundle.message("duplicate.property.diff.key.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_DUPLICATE_KEYS", (String)PropertiesBundle.message("duplicate.property.key.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(8);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("SCOPE", () -> this.CURRENT_FILE ? "file" : (this.MODULE_WITH_DEPENDENCIES ? "module" : "project"), value -> {
            this.CURRENT_FILE = "file".equals(value);
            this.MODULE_WITH_DEPENDENCIES = "module".equals(value);
        });
        if (optionController == null) {
            DuplicatePropertyInspection.$$$reportNull$$$0(9);
        }
        return optionController;
    }

    private /* synthetic */ void lambda$checkFile$1(List properties, ProgressIndicator progress, ProgressIndicator original, Map processedValueToFiles, Map processedKeyToFiles, PsiSearchHelper searchHelper, GlobalSearchScope scope, InspectionManager manager, PsiFile file, ProblemDescriptionsProcessor processor, RefManager refManager) {
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(properties, progress, property -> {
            if (original != null) {
                if (original.isCanceled()) {
                    return false;
                }
                original.setText2(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
            }
            DuplicatePropertyInspection.processTextUsages(processedValueToFiles, property.getValue(), processedKeyToFiles, searchHelper, scope);
            DuplicatePropertyInspection.processTextUsages(processedKeyToFiles, property.getUnescapedKey(), processedValueToFiles, searchHelper, scope);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
        ArrayList problemDescriptors = new ArrayList();
        HashMap<String, Set<String>> keyToDifferentValues = new HashMap<String, Set<String>>();
        if (this.CHECK_DUPLICATE_KEYS || this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES) {
            this.prepareDuplicateKeysByFile(processedKeyToFiles, manager, keyToDifferentValues, problemDescriptors, file, original);
        }
        if (this.CHECK_DUPLICATE_VALUES) {
            DuplicatePropertyInspection.prepareDuplicateValuesByFile(processedValueToFiles, manager, problemDescriptors, file, original);
        }
        if (this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES) {
            DuplicatePropertyInspection.processDuplicateKeysWithDifferentValues(keyToDifferentValues, processedKeyToFiles, problemDescriptors, manager, file, original);
        }
        if (!problemDescriptors.isEmpty()) {
            processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)file), (CommonProblemDescriptor[])problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineAnchor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "surroundWithHref";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compoundLineLink";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

