/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradient.ui.basic;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.gradient.GradientBar;
import com.michaelbaranov.microba.gradient.ui.GradientListener;
import com.michaelbaranov.microba.gradient.ui.GradientUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicGradientUI
extends GradientUI {
    public static ComponentUI createUI(JComponent c) {
        return new BasicGradientUI();
    }

    @Override
    public void installUI(JComponent component) {
        this.installListeners((GradientBar)component);
    }

    @Override
    public void uninstallUI(JComponent component) {
        this.uninstallListeners((GradientBar)component);
    }

    protected void installListeners(GradientBar gradient) {
        GradientListener listener = this.createListener(gradient);
        if (gradient.getDataModel() != null) {
            gradient.getDataModel().addTableModelListener(listener);
        }
        gradient.addPropertyChangeListener(listener);
    }

    protected void uninstallListeners(GradientBar gradient) {
        GradientListener listener = this.lookupListsner(gradient);
        if (listener != null) {
            if (gradient.getDataModel() != null) {
                gradient.getDataModel().removeTableModelListener(listener);
            }
            gradient.removePropertyChangeListener(listener);
        }
    }

    protected GradientListener lookupListsner(GradientBar gradient) {
        PropertyChangeListener[] listeners = gradient.getPropertyChangeListeners();
        if (listeners != null) {
            for (int counter = 0; counter < listeners.length; ++counter) {
                if (!(listeners[counter] instanceof GradientListener)) continue;
                return (GradientListener)listeners[counter];
            }
        }
        return null;
    }

    protected GradientListener createListener(GradientBar gradient) {
        return new GradientListener(this, gradient);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        GradientBar gradient = (GradientBar)c;
        this.calculateViewRect(gradient);
        BoundedTableModel colorModel = gradient.getDataModel();
        BoundedTableModel alphaModel = gradient.getAlphaModel();
        if (colorModel == null) {
            return;
        }
        int numColorPoints = colorModel.getRowCount();
        int numAlphaPoints = alphaModel == null ? 0 : alphaModel.getRowCount();
        int colorPositionColumn = gradient.getColorPositionColumn();
        int colorColumn = gradient.getColorColumn();
        int alphaPositionColumn = gradient.getAlphaPositionColumn();
        int alphaColumn = gradient.getAlphaColumn();
        switch (numColorPoints) {
            case 0: {
                break;
            }
            case 1: {
                g.setColor((Color)colorModel.getValueAt(0, colorColumn));
                g.fillRect(BasicGradientUI.viewRect.x, BasicGradientUI.viewRect.y, BasicGradientUI.viewRect.width, BasicGradientUI.viewRect.height);
                break;
            }
            default: {
                GradientUI.PreparedColorPoint[] pts = this.prepareColorPoints(colorModel, colorPositionColumn, colorColumn);
                int range = colorModel.getUpperBound() - colorModel.getLowerBound();
                boolean isHorizontal = gradient.getOrientation() == 0;
                for (int i = 0; i < numColorPoints - 1; ++i) {
                    int pixPos1;
                    int pixPos0;
                    GradientUI.PreparedColorPoint p0 = pts[i];
                    GradientUI.PreparedColorPoint p1 = pts[i + 1];
                    int pos0 = p0.position - colorModel.getLowerBound();
                    int pos1 = p1.position - colorModel.getLowerBound();
                    if (isHorizontal) {
                        pixPos0 = BasicGradientUI.viewRect.x + BasicGradientUI.viewRect.width * pos0 / range;
                        pixPos1 = BasicGradientUI.viewRect.x + BasicGradientUI.viewRect.width * pos1 / range;
                    } else {
                        pixPos0 = BasicGradientUI.viewRect.y + BasicGradientUI.viewRect.height * pos0 / range;
                        pixPos1 = BasicGradientUI.viewRect.y + BasicGradientUI.viewRect.height * pos1 / range;
                    }
                    int pixDist = pixPos1 - pixPos0;
                    for (int t = pixPos0; t < pixPos1; ++t) {
                        Color cc = this.interpolate(p0, p1, pixDist, t - pixPos0);
                        g2.setColor(cc);
                        if (isHorizontal) {
                            g2.drawLine(t, BasicGradientUI.viewRect.y, t, BasicGradientUI.viewRect.y + BasicGradientUI.viewRect.height);
                            continue;
                        }
                        g2.drawLine(BasicGradientUI.viewRect.x, t, BasicGradientUI.viewRect.x + BasicGradientUI.viewRect.width, t);
                    }
                }
            }
        }
    }

    private Color interpolate(GradientUI.PreparedColorPoint p0, GradientUI.PreparedColorPoint p1, int pixDist, int t) {
        int r = p0.r + (p1.r - p0.r) * t / pixDist;
        int g = p0.g + (p1.g - p0.g) * t / pixDist;
        int b = p0.b + (p1.b - p0.b) * t / pixDist;
        return new Color(r, g, b);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(1, 1);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        GradientBar gradient = (GradientBar)c;
        BoundedTableModel dataModel = gradient.getDataModel();
        Insets ins = gradient.getInsets();
        int r = dataModel == null ? 1 : dataModel.getUpperBound() - dataModel.getLowerBound();
        if (gradient.getOrientation() == 0) {
            return new Dimension(r * 2 + ins.left + ins.right + 1, 32 + ins.top + ins.bottom + 1);
        }
        return new Dimension(32 + ins.top + ins.bottom + 1, r * 2 + ins.left + ins.right + 1);
    }
}

