/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.Normalization;

public class NormalizationH1
extends Normalization {
    private final float c;

    public NormalizationH1(float c) {
        if (!Float.isFinite(c) || c < 0.0f) {
            throw new IllegalArgumentException("illegal c value: " + c + ", must be a non-negative finite value");
        }
        this.c = c;
    }

    public NormalizationH1() {
        this(1.0f);
    }

    @Override
    public final double tfn(BasicStats stats2, double tf, double len) {
        return tf * (double)this.c * (stats2.getAvgFieldLength() / len);
    }

    @Override
    public Explanation explain(BasicStats stats2, double tf, double len) {
        return Explanation.match((Number)Float.valueOf((float)this.tfn(stats2, tf, len)), this.getClass().getSimpleName() + ", computed as tf * c * (avgfl / fl) from:", Explanation.match((Number)Float.valueOf((float)tf), "tf, number of occurrences of term in the document", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.c), "c, hyper-parameter", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)stats2.getAvgFieldLength()), "avgfl, average length of field across all documents", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)len), "fl, field length of the document", new Explanation[0]));
    }

    @Override
    public String toString() {
        return "1";
    }

    public float getC() {
        return this.c;
    }
}

