/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.config.SerializationHelper;
import com.intellij.internal.statistic.eventLog.events.scheme.EventSchemeValidator;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsScheme;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "commandName", "", "getCommandName", "()Ljava/lang/String;", "getPluginsToSkipSchemeGeneration", "", "logEnabledPlugins", "", "pluginsFile", "main", "args", "", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nEventsSchemeBuilderAppStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsSchemeBuilderAppStarter.kt\ncom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n10#2:91\n766#3:92\n857#3,2:93\n*S KotlinDebug\n*F\n+ 1 EventsSchemeBuilderAppStarter.kt\ncom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter\n*L\n19#1:91\n55#1:92\n55#1:93,2\n*E\n"})
public final class EventsSchemeBuilderAppStarter
implements ApplicationStarter {
    @NotNull
    private final Logger LOG;

    public EventsSchemeBuilderAppStarter() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EventsSchemeBuilderAppStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.LOG = logger;
    }

    @NotNull
    public String getCommandName() {
        return "buildEventsScheme";
    }

    /*
     * WARNING - void declaration
     */
    public void main(@NotNull List<String> args) {
        List list;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String outputFile = null;
        String pluginsFile = null;
        String pluginId = null;
        String errorsFile = null;
        for (String arg : args) {
            if (StringsKt.startsWith$default((String)arg, (String)"--outputFile=", (boolean)false, (int)2, null)) {
                outputFile = StringsKt.substringAfter$default((String)arg, (String)"--outputFile=", null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"--pluginsFile=", (boolean)false, (int)2, null)) {
                pluginsFile = StringsKt.substringAfter$default((String)arg, (String)"--pluginsFile=", null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)"--pluginId=", (boolean)false, (int)2, null)) {
                pluginId = StringsKt.substringAfter$default((String)arg, (String)"--pluginId=", null, (int)2, null);
                continue;
            }
            if (!StringsKt.startsWith$default((String)arg, (String)"--errorsFile=", (boolean)false, (int)2, null)) continue;
            errorsFile = StringsKt.substringAfter$default((String)arg, (String)"--errorsFile=", null, (int)2, null);
        }
        List<GroupDescriptor> groups = EventsSchemeBuilder.buildEventsScheme(null, pluginId, this.getPluginsToSkipSchemeGeneration());
        Map<GroupDescriptor, List<String>> errors = EventSchemeValidator.validateEventScheme(groups);
        List errorsList = CollectionsKt.flatten((Iterable)errors.values());
        if (!((Collection)errorsList).isEmpty()) {
            String errorsListString = CollectionsKt.joinToString$default((Iterable)errorsList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            this.LOG.error((Throwable)new IllegalStateException(errorsListString));
            if (errorsFile != null) {
                FileUtil.writeToFile((File)new File(errorsFile), (String)errorsListString);
            }
        }
        Iterable iterable = groups;
        String string = System.getenv("IDEA_BUILD_NUMBER");
        String string2 = System.getenv("INSTALLER_LAST_COMMIT_HASH");
        boolean $i$f$filter = false;
        void var12_14 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GroupDescriptor it = (GroupDescriptor)element$iv$iv;
            boolean bl = false;
            List<String> list2 = errors.get(it);
            if (!(list2 != null ? list2.isEmpty() : true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        String string3 = string;
        String string4 = string2;
        EventsScheme eventsScheme = new EventsScheme(string4, string3, list3);
        String text = SerializationHelper.Companion.serialize(eventsScheme);
        this.logEnabledPlugins(pluginsFile);
        if (outputFile != null) {
            FileUtil.writeToFile((File)new File(outputFile), (String)text);
        } else {
            System.out.println((Object)text);
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void logEnabledPlugins(String pluginsFile) {
        StringBuilder stringBuilder;
        StringBuilder $this$logEnabledPlugins_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getLoadedPlugins()) {
            if (!descriptor.isEnabled()) continue;
            StringBuilder stringBuilder2 = $this$logEnabledPlugins_u24lambda_u241.append(descriptor.getPluginId().getIdString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String text = string;
        if (pluginsFile != null) {
            FileUtil.writeToFile((File)new File(pluginsFile), (String)text);
        } else {
            System.out.println((Object)"Enabled plugins:");
            System.out.println((Object)text);
        }
    }

    private final Set<String> getPluginsToSkipSchemeGeneration() {
        String skipGenerationOfBrokenPlugins = System.getenv("SKIP_GENERATION_OF_BROKEN_PLUGINS");
        if (skipGenerationOfBrokenPlugins == null) {
            return SetsKt.emptySet();
        }
        String[] stringArray = new String[]{","};
        return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)skipGenerationOfBrokenPlugins, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }
}

