/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.features;

import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.searchEverywhereMl.ranking.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.features.SearchEverywhereFileFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.features.SearchEverywherePsiElementFeaturesProviderUtils;
import com.intellij.textMatching.PrefixMatchingUtil;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0004H\u0016J'\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereFileFeaturesProvider;", "Lcom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereElementFeaturesProvider;", "()V", "getElementFeatures", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/searchEverywhereMl/ranking/features/FeaturesProviderCache;", "getFeaturesDeclarations", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getRelativePathNameMatchingFeatures", "", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "getRelativePathNameMatchingFeatures$intellij_searchEverywhereMl_ranking", "isBookmark", "", "isExactMatch", "isExactRelativePath", "isTopLevel", "(Lcom/intellij/psi/PsiFileSystemItem;)Ljava/lang/Boolean;", "matchesFileTypeInQuery", "(Lcom/intellij/psi/PsiFileSystemItem;Ljava/lang/String;)Ljava/lang/Boolean;", "Companion", "intellij.searchEverywhereMl.ranking"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSearchEverywhereFileFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereFileFeaturesProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n215#2,2:187\n1#3:189\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereFileFeaturesProvider\n*L\n159#1:187,2\n*E\n"})
public final class SearchEverywhereFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final StringEventField FILETYPE_DATA_KEY = EventFields.StringValidatedByCustomRule((String)"fileType", (String)"file_type");
    @NotNull
    private static final BooleanEventField IS_BOOKMARK_DATA_KEY = EventFields.Boolean((String)"isBookmark");
    @NotNull
    private static final BooleanEventField IS_DIRECTORY_DATA_KEY = EventFields.Boolean((String)"isDirectory");
    @NotNull
    private static final BooleanEventField IS_EXACT_MATCH_DATA_KEY = EventFields.Boolean((String)"isExactMatch");
    @NotNull
    private static final BooleanEventField FILETYPE_MATCHES_QUERY_DATA_KEY = EventFields.Boolean((String)"fileTypeMatchesQuery");
    @NotNull
    private static final BooleanEventField IS_TOP_LEVEL_DATA_KEY = EventFields.Boolean((String)"isTopLevel");
    @NotNull
    private static final BooleanEventField IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY = EventFields.Boolean((String)"isExactRelativePath");
    @NotNull
    private static final HashMap<String, EventField<?>> REL_PATH_NAME_FEATURE_TO_FIELD;

    public SearchEverywhereFileFeaturesProvider() {
        Class[] classArray = new Class[]{FileSearchEverywhereContributor.class, RecentFilesSEContributor.class};
        super(classArray);
    }

    @Override
    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        Object[] objectArray = new EventField[]{IS_DIRECTORY_DATA_KEY, FILETYPE_DATA_KEY, IS_BOOKMARK_DATA_KEY, IS_EXACT_MATCH_DATA_KEY, FILETYPE_MATCHES_QUERY_DATA_KEY, IS_TOP_LEVEL_DATA_KEY, IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY};
        Collection collection = CollectionsKt.arrayListOf((Object[])objectArray);
        Collection<EventField<?>> collection2 = REL_PATH_NAME_FEATURE_TO_FIELD.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"REL_PATH_NAME_FEATURE_TO_FIELD.values");
        return CollectionsKt.plus((Collection)collection, (Iterable)collection2);
    }

    @Override
    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Object[] objectArray = SearchEverywherePsiElementFeaturesProviderUtils.INSTANCE.getPsiElement(element);
        PsiFileSystemItem psiFileSystemItem = objectArray instanceof PsiFileSystemItem ? (PsiFileSystemItem)objectArray : null;
        if (psiFileSystemItem == null) {
            return CollectionsKt.emptyList();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        objectArray = new EventPair[]{IS_BOOKMARK_DATA_KEY.with((Object)this.isBookmark(item)), IS_DIRECTORY_DATA_KEY.with((Object)item.isDirectory()), IS_EXACT_MATCH_DATA_KEY.with((Object)this.isExactMatch(item, searchQuery, elementPriority)), IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY.with((Object)this.isExactRelativePath(item, searchQuery))};
        ArrayList data = CollectionsKt.arrayListOf((Object[])objectArray);
        data.addAll(this.getRelativePathNameMatchingFeatures$intellij_searchEverywhereMl_ranking(item, searchQuery));
        this.putIfValueNotNull(data, (EventField)IS_TOP_LEVEL_DATA_KEY, this.isTopLevel(item));
        if (item.isDirectory()) {
            return data;
        }
        data.add(FILETYPE_DATA_KEY.with((Object)item.getVirtualFile().getFileType().getName()));
        this.putIfValueNotNull(data, (EventField)FILETYPE_MATCHES_QUERY_DATA_KEY, this.matchesFileTypeInQuery(item, searchQuery));
        return data;
    }

    private final boolean isBookmark(PsiFileSystemItem item) {
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)item.getProject());
        Boolean bkm = (Boolean)ReadAction.compute(() -> SearchEverywhereFileFeaturesProvider.isBookmark$lambda$2(item, bookmarksManager));
        Intrinsics.checkNotNullExpressionValue((Object)bkm, (String)"bkm");
        return bkm;
    }

    private final boolean isExactMatch(PsiFileSystemItem item, String searchQuery, int elementPriority) {
        if (elementPriority == 5000) {
            return true;
        }
        String string = item.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.virtualFile.path");
        String filePath = string;
        String string2 = item.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.virtualFile.name");
        String fileName = string2;
        return SequencesKt.none((Sequence)SequencesKt.filterIndexed((Sequence)SequencesKt.map((Sequence)StringsKt.asSequence((CharSequence)searchQuery), (Function1)isExactMatch.1.INSTANCE), (Function2)((Function2)new Function2<Integer, Character, Boolean>(searchQuery, fileName, filePath){
            final /* synthetic */ String $searchQuery;
            final /* synthetic */ String $fileName;
            final /* synthetic */ String $filePath;
            {
                this.$searchQuery = $searchQuery;
                this.$fileName = $fileName;
                this.$filePath = $filePath;
                super(2);
            }

            @NotNull
            public final Boolean invoke(int searchQueryCharIndex, char c) {
                if (searchQueryCharIndex == 0 && c == '/' && this.$searchQuery.length() - 1 == this.$fileName.length()) {
                    return true;
                }
                Integer n = this.$filePath.length() - this.$searchQuery.length() + searchQueryCharIndex;
                int it = ((Number)n).intValue();
                boolean bl = false;
                Integer n2 = it >= 0 ? n : null;
                if (n2 == null) {
                    return true;
                }
                int index = n2;
                return this.$filePath.charAt(index) != c;
            }
        })));
    }

    private final boolean isExactRelativePath(PsiFileSystemItem item, String searchQuery) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        Path path = SearchEverywhereFileFeaturesProvider.Companion.toNioPathOrNull(virtualFile);
        if (path == null) {
            return false;
        }
        Path filePath = path;
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"item.project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = SearchEverywhereFileFeaturesProvider.Companion.toNioPathOrNull((VirtualFile)object)) == null) {
            return false;
        }
        Object basePath = object;
        Path path2 = NioPathUtil.toNioPathOrNull((String)searchQuery);
        if (path2 == null) {
            return false;
        }
        Path queryPath = path2;
        try {
            Path relativePath = basePath.relativize(filePath);
            return Intrinsics.areEqual((Object)queryPath, (Object)relativePath);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @NotNull
    public final Collection<EventPair<?>> getRelativePathNameMatchingFeatures$intellij_searchEverywhereMl_ranking(@NotNull PsiFileSystemItem item, @NotNull String searchQuery) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"item.virtualFile");
        Path path = SearchEverywhereFileFeaturesProvider.Companion.toNioPathOrNull(virtualFile);
        if (path == null) {
            return CollectionsKt.emptyList();
        }
        Path filePath = path;
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"item.project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = SearchEverywhereFileFeaturesProvider.Companion.toNioPathOrNull((VirtualFile)object)) == null) {
            return CollectionsKt.emptyList();
        }
        Object basePath = object;
        Path relativePath = basePath.relativize(filePath);
        Map features2 = new LinkedHashMap();
        PrefixMatchingUtil.INSTANCE.calculateFeatures(((Object)relativePath).toString(), searchQuery, features2);
        ArrayList result = new ArrayList();
        Map $this$forEach$iv = REL_PATH_NAME_FEATURE_TO_FIELD;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            EventPair<?> it;
            Object matchValue;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            EventField field = (EventField)entry.getValue();
            if (features2.get(key) == null) continue;
            if (this.setMatchValueToField$intellij_searchEverywhereMl_ranking(matchValue, field) == null) continue;
            boolean bl2 = false;
            result.add(it);
        }
        return result;
    }

    private final Boolean isTopLevel(PsiFileSystemItem item) {
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"item.project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object basePath = object;
        Object object2 = item.getVirtualFile().getParent();
        if (object2 == null || (object2 = object2.getPath()) == null) {
            return null;
        }
        Object fileDirectoryPath = object2;
        return Intrinsics.areEqual((Object)fileDirectoryPath, (Object)basePath);
    }

    private final Boolean matchesFileTypeInQuery(PsiFileSystemItem item, String searchQuery) {
        String fileExtension = item.getVirtualFile().getExtension();
        String extensionInQuery = StringsKt.substringAfterLast((String)searchQuery, (char)'.', (String)"");
        if (((CharSequence)extensionInQuery).length() == 0 || fileExtension == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)extensionInQuery, (Object)fileExtension);
    }

    private static final Boolean isBookmark$lambda$2(PsiFileSystemItem $item, BookmarksManager $bookmarksManager) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        VirtualFile virtualFile = $item.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile vFile = virtualFile;
            boolean bl = false;
            Object object = $bookmarksManager;
            if (object != null && (object = object.getBookmarks()) != null) {
                Object v2;
                block5: {
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        Bookmark it = (Bookmark)t;
                        boolean bl2 = false;
                        if (!(it instanceof FileBookmark && Intrinsics.areEqual((Object)((FileBookmark)it).getFile(), (Object)vFile))) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                bookmark = v2;
            } else {
                bookmark = null;
            }
        } else {
            bookmark = null;
        }
        return bookmark != null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"prefix_same_start_count", (Object)EventFields.Int((String)"relPathPrefixSameStartCount")), TuplesKt.to((Object)"prefix_greedy_score", (Object)EventFields.Double((String)"relPathPrefixGreedyScore")), TuplesKt.to((Object)"prefix_matched_words_score", (Object)EventFields.Double((String)"relPathPrefixMatchedWordsScore")), TuplesKt.to((Object)"prefix_matched_words_relative", (Object)EventFields.Double((String)"relPathPrefixMatchedWordsRelative"))};
        REL_PATH_NAME_FEATURE_TO_FIELD = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR8\u0010\u0015\u001a&\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0016j\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018`\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereFileFeaturesProvider$Companion;", "", "()V", "FILETYPE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getFILETYPE_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "FILETYPE_MATCHES_QUERY_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_BOOKMARK_DATA_KEY", "getIS_BOOKMARK_DATA_KEY", "IS_DIRECTORY_DATA_KEY", "getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl_ranking", "IS_EXACT_MATCH_DATA_KEY", "getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl_ranking", "IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY", "getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking", "IS_TOP_LEVEL_DATA_KEY", "getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl_ranking", "REL_PATH_NAME_FEATURE_TO_FIELD", "Ljava/util/HashMap;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "Lkotlin/collections/HashMap;", "getREL_PATH_NAME_FEATURE_TO_FIELD$intellij_searchEverywhereMl_ranking", "()Ljava/util/HashMap;", "toNioPathOrNull", "Ljava/nio/file/Path;", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.searchEverywhereMl.ranking"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringEventField getFILETYPE_DATA_KEY() {
            return FILETYPE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_BOOKMARK_DATA_KEY() {
            return IS_BOOKMARK_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return IS_DIRECTORY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return IS_EXACT_MATCH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return FILETYPE_MATCHES_QUERY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return IS_TOP_LEVEL_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY;
        }

        @NotNull
        public final HashMap<String, EventField<?>> getREL_PATH_NAME_FEATURE_TO_FIELD$intellij_searchEverywhereMl_ranking() {
            return REL_PATH_NAME_FEATURE_TO_FIELD;
        }

        private final Path toNioPathOrNull(VirtualFile $this$toNioPathOrNull) {
            Path path;
            try {
                path = $this$toNioPathOrNull.toNioPath();
            }
            catch (UnsupportedOperationException e) {
                path = null;
            }
            catch (InvalidPathException e) {
                path = null;
            }
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

