/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.thumbnail.actions.ShowBorderAction;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ImageComponentDecorator;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageEditorUI
extends JPanel
implements DataProvider,
CopyProvider,
ImageComponentDecorator,
Disposable {
    @NonNls
    private static final String IMAGE_PANEL = "image";
    @NonNls
    private static final String ERROR_PANEL = "error";
    @NonNls
    private static final String ZOOM_FACTOR_PROP = "ImageEditor.zoomFactor";
    @Nullable
    private final ImageEditor editor;
    private final DeleteProvider deleteProvider;
    private final CopyPasteSupport copyPasteSupport;
    private final ImageZoomModel zoomModel = new ImageZoomModelImpl();
    private final ImageWheelAdapter wheelAdapter = new ImageWheelAdapter();
    private final ChangeListener changeListener = new DocumentChangeListener();
    private final ImageComponent imageComponent = new ImageComponent();
    private final JPanel contentPanel;
    private JLabel infoLabel = null;
    private final JScrollPane myScrollPane;
    private final boolean isEmbedded;

    ImageEditorUI(@Nullable ImageEditor editor) {
        this(editor, false, false);
    }

    ImageEditorUI(@Nullable ImageEditor editor, boolean isEmbedded, boolean isOpaque) {
        this.editor = editor;
        this.isEmbedded = isEmbedded;
        this.imageComponent.addPropertyChangeListener(ZOOM_FACTOR_PROP, e -> this.imageComponent.setZoomFactor(this.getZoomModel().getZoomFactor()));
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        options.addPropertyChangeListener(new OptionsChangeListener(), this);
        this.copyPasteSupport = editor != null ? new CopyPasteDelegator(editor.getProject(), (JComponent)this) : null;
        this.deleteProvider = new DeleteHandler.DefaultDeleteProvider();
        ImageDocument document = this.imageComponent.getDocument();
        document.addChangeListener(this.changeListener);
        TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        this.imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
        this.imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
        this.imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
        this.imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
        this.imageComponent.setGridLineSpan(gridOptions.getLineSpan());
        this.imageComponent.setGridLineColor(gridOptions.getLineColor());
        this.imageComponent.setBorderVisible(ShowBorderAction.isBorderVisible());
        ImageContainerPane view = new ImageContainerPane(this.imageComponent);
        PopupHandler.installPopupMenu((JComponent)((Object)view), (String)"Images.EditorPopupMenu", (String)"Images.Editor");
        view.addMouseListener(new FocusRequester());
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)view), (boolean)true);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.addMouseWheelListener(this.wheelAdapter);
        this.setLayout(new BorderLayout());
        JComponent toolbarPanel = null;
        if (!isEmbedded) {
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.EditorToolbar");
            ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Editor", actionGroup, true);
            actionToolbar.setTargetComponent((JComponent)this);
            toolbarPanel = actionToolbar.getComponent();
            toolbarPanel.setBackground((Color)JBColor.lazy(() -> this.getBackground()));
            toolbarPanel.addMouseListener(new FocusRequester());
        }
        JLabel errorLabel = new JLabel(ImagesBundle.message("error.broken.image.file.format", new Object[0]), Messages.getErrorIcon(), 0);
        JPanel errorPanel = new JPanel(new BorderLayout());
        errorPanel.add((Component)errorLabel, "Center");
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)this.myScrollPane, IMAGE_PANEL);
        this.contentPanel.add((Component)errorPanel, ERROR_PANEL);
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        if (!isEmbedded) {
            topPanel.add((Component)toolbarPanel, "West");
            this.infoLabel = new JLabel((String)null, 4);
            this.infoLabel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
            topPanel.add((Component)this.infoLabel, "East");
        }
        this.add((Component)topPanel, "North");
        this.add((Component)this.contentPanel, "Center");
        this.myScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageEditorUI.this.updateZoomFactor();
            }
        });
        if (!isOpaque) {
            this.contentPanel.setOpaque(false);
            this.myScrollPane.setOpaque(false);
            this.myScrollPane.getViewport().setOpaque(false);
        }
        this.setBackground((Color)JBColor.lazy(() -> (Color)ObjectUtils.notNull((Object)EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.PREVIEW_BACKGROUND), (Object)EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground())));
        this.updateInfo();
    }

    private void updateInfo() {
        if (this.isEmbedded) {
            return;
        }
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage image = document.getValue();
        if (image != null) {
            ColorModel colorModel = image.getColorModel();
            String format = document.getFormat();
            format = format == null ? (this.editor != null ? ImagesBundle.message("unknown.format", new Object[0]) : "") : StringUtil.toUpperCase((String)format);
            VirtualFile file = this.editor != null ? this.editor.getFile() : null;
            this.infoLabel.setText(ImagesBundle.message("image.info", image.getWidth(), image.getHeight(), format, colorModel.getPixelSize(), file != null ? StringUtil.formatFileSize((long)file.getLength()) : ""));
        } else {
            this.infoLabel.setText(null);
        }
    }

    JComponent getContentComponent() {
        return this.contentPanel;
    }

    ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    public void dispose() {
        this.imageComponent.removeMouseWheelListener(this.wheelAdapter);
        this.imageComponent.getDocument().removeChangeListener(this.changeListener);
        this.removeAll();
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        this.imageComponent.setTransparencyChessboardVisible(visible);
        this.repaint();
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.imageComponent.isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return !"Images.Thumbnails".equals(place);
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.imageComponent.setGridVisible(visible);
        this.repaint();
    }

    @Override
    public boolean isGridVisible() {
        return this.imageComponent.isGridVisible();
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return this.zoomModel;
    }

    public void setImageProvider(ImageDocument.ScaledImageProvider imageProvider, String format) {
        ZoomOptions zoomOptions;
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage previousImage = document.getValue();
        document.setValue(imageProvider);
        if (imageProvider == null) {
            return;
        }
        document.setFormat(format);
        if (!(previousImage != null && this.zoomModel.isZoomLevelChanged() || (zoomOptions = this.getZoomOptions()).isSmartZooming() && this.updateZoomFactor())) {
            this.zoomModel.setZoomFactor(1.0);
        }
    }

    private boolean updateZoomFactor() {
        Double smartZoomFactor;
        ZoomOptions zoomOptions = this.getZoomOptions();
        if (zoomOptions.isSmartZooming() && !this.zoomModel.isZoomLevelChanged() && (smartZoomFactor = zoomOptions.getSmartZoomFactor(this.imageComponent.getDocument().getBounds(), this.myScrollPane.getViewport().getExtentSize(), 2)) != null) {
            this.zoomModel.setZoomFactor(smartZoomFactor);
            return true;
        }
        return false;
    }

    private ZoomOptions getZoomOptions() {
        Cloneable options;
        ImageEditor editor = this.editor;
        if (editor != null && (options = editor.getZoomModel().getCustomZoomOptions()) != null) {
            return options;
        }
        options = OptionsManager.getInstance().getOptions();
        return options.getEditorOptions().getZoomOptions();
    }

    private void updateImageComponentSize() {
        Rectangle bounds = this.imageComponent.getDocument().getBounds();
        if (bounds != null) {
            double zoom = this.getZoomModel().getZoomFactor();
            this.imageComponent.setCanvasSize((int)Math.ceil((double)bounds.width * zoom), (int)Math.ceil((double)bounds.height * zoom));
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ImageEditorUI.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.editor != null ? this.editor.getProject() : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.editor != null ? this.editor.getFile() : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            VirtualFile[] virtualFileArray;
            if (this.editor != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = this.editor.getFile();
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId) && this.copyPasteSupport != null) {
            return this.copyPasteSupport.getCutProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.deleteProvider;
        }
        if (ImageComponentDecorator.DATA_KEY.is(dataId)) {
            return this.editor != null ? this.editor : this;
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            return slowId -> this.getSlowData(slowId);
        }
        return null;
    }

    @Nullable
    private Object getSlowData(@NotNull String dataId) {
        if (dataId == null) {
            ImageEditorUI.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            return this.findPsiFile();
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.findPsiFile();
        }
        if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] psiElementArray;
            PsiFile psi = this.findPsiFile();
            if (psi != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = psi;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }
        return null;
    }

    @Nullable
    private PsiFile findPsiFile() {
        VirtualFile file = this.editor != null ? this.editor.getFile() : null;
        return file != null && file.isValid() ? PsiManager.getInstance((Project)this.editor.getProject()).findFile(file) : null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ImageEditorUI.$$$reportNull$$$0(2);
        }
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage image = document.getValue();
        CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(image));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ImageEditorUI.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ImageEditorUI.$$$reportNull$$$0(4);
        }
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ImageEditorUI.$$$reportNull$$$0(5);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/editor/impl/ImageEditorUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/editor/impl/ImageEditorUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class ImageZoomModelImpl
    implements ImageZoomModel {
        @Nullable
        private ZoomOptions myCustomZoomOptions;
        private boolean myZoomLevelChanged;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        LazyInitializer.LazyValue<@NotNull Double> IMAGE_MAX_ZOOM_FACTOR = LazyInitializer.create(() -> {
            if (ImageEditorUI.this.editor == null) {
                return Double.MAX_VALUE;
            }
            VirtualFile file = ImageEditorUI.this.editor.getFile();
            if (IfsUtil.isSVG(file)) {
                try {
                    return Math.max(1.0, SVGLoader.INSTANCE.getMaxZoomFactor(file.contentsToByteArray(), ScaleContext.create((Component)ImageEditorUI.this.editor.getComponent())));
                }
                catch (Throwable t) {
                    Logger.getInstance(ImageEditorUI.class).warn(t);
                }
            }
            return Double.MAX_VALUE;
        });
        private double zoomFactor = 0.0;

        private ImageZoomModelImpl() {
        }

        @Override
        public double getZoomFactor() {
            return this.zoomFactor;
        }

        @Override
        public void setZoomFactor(double zoomFactor) {
            double oldZoomFactor = this.getZoomFactor();
            if (Double.compare(oldZoomFactor, zoomFactor) == 0) {
                return;
            }
            this.zoomFactor = zoomFactor;
            ImageEditorUI.this.updateImageComponentSize();
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
            this.myZoomLevelChanged = false;
            ImageEditorUI.this.imageComponent.firePropertyChange(ImageEditorUI.ZOOM_FACTOR_PROP, oldZoomFactor, zoomFactor);
        }

        private double getMaximumZoomFactor() {
            double factor = (Double)this.IMAGE_MAX_ZOOM_FACTOR.get();
            return Math.min(factor, MACRO_ZOOM_LIMIT);
        }

        private double getMinimumZoomFactor() {
            Rectangle bounds = ImageEditorUI.this.imageComponent.getDocument().getBounds();
            double factor = bounds != null ? 1.0 / bounds.getWidth() : 0.0;
            return Math.max(factor, MICRO_ZOOM_LIMIT);
        }

        @Override
        public void fitZoomToWindow() {
            ZoomOptions zoomOptions = ImageEditorUI.this.getZoomOptions();
            Double smartZoomFactor = zoomOptions.getSmartZoomFactor(ImageEditorUI.this.imageComponent.getDocument().getBounds(), ImageEditorUI.this.myScrollPane.getViewport().getExtentSize(), 2);
            if (smartZoomFactor != null) {
                ImageEditorUI.this.zoomModel.setZoomFactor(smartZoomFactor);
            } else {
                ImageEditorUI.this.zoomModel.setZoomFactor(1.0);
            }
            this.myZoomLevelChanged = false;
        }

        @Override
        public void zoomOut() {
            this.setZoomFactor(this.getNextZoomOut());
            this.myZoomLevelChanged = true;
        }

        @Override
        public void zoomIn() {
            this.setZoomFactor(this.getNextZoomIn());
            this.myZoomLevelChanged = true;
        }

        private double getNextZoomOut() {
            double factor = this.getZoomFactor();
            if (factor > 1.0) {
                factor /= 2.0;
                factor = Math.max(factor, 1.0);
            } else {
                factor /= 1.5;
            }
            return Math.max(factor, this.getMinimumZoomFactor());
        }

        private double getNextZoomIn() {
            double factor = this.getZoomFactor();
            if (factor >= 1.0) {
                factor *= 2.0;
            } else {
                factor *= 1.5;
                factor = Math.min(factor, 1.0);
            }
            return Math.min(factor, this.getMaximumZoomFactor());
        }

        @Override
        public boolean canZoomOut() {
            return this.getZoomFactor() - 1.0E-14 > this.getMinimumZoomFactor();
        }

        @Override
        public boolean canZoomIn() {
            return this.getZoomFactor() < this.getMaximumZoomFactor();
        }

        @Override
        public void setZoomLevelChanged(boolean value) {
            this.myZoomLevelChanged = value;
        }

        @Override
        public boolean isZoomLevelChanged() {
            return this.myZoomLevelChanged;
        }

        @Override
        @Nullable
        public ZoomOptions getCustomZoomOptions() {
            return this.myCustomZoomOptions;
        }

        @Override
        public void setCustomZoomOptions(@Nullable ZoomOptions zoomOptions) {
            this.myCustomZoomOptions = zoomOptions;
        }
    }

    private final class ImageWheelAdapter
    implements MouseWheelListener {
        private ImageWheelAdapter() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Options options = OptionsManager.getInstance().getOptions();
            EditorOptions editorOptions = options.getEditorOptions();
            ZoomOptions zoomOptions = editorOptions.getZoomOptions();
            if (zoomOptions.isWheelZooming() && e.isControlDown()) {
                int rotation = e.getWheelRotation();
                double oldZoomFactor = ImageEditorUI.this.zoomModel.getZoomFactor();
                Point oldPosition = ImageEditorUI.this.myScrollPane.getViewport().getViewPosition();
                if (rotation > 0) {
                    ImageEditorUI.this.zoomModel.zoomOut();
                } else if (rotation < 0) {
                    ImageEditorUI.this.zoomModel.zoomIn();
                }
                Component view = ImageEditorUI.this.myScrollPane.getViewport().getView();
                ImageEditorUI.this.myScrollPane.setViewport(null);
                ImageEditorUI.this.myScrollPane.setViewportView(view);
                if (oldZoomFactor > 0.0 && rotation != 0) {
                    Point mousePoint = e.getPoint();
                    double zoomChange = ImageEditorUI.this.zoomModel.getZoomFactor() / oldZoomFactor;
                    Point newPosition = new Point((int)Math.max(0.0, (oldPosition.getX() + mousePoint.getX()) * zoomChange - mousePoint.getX()), (int)Math.max(0.0, (oldPosition.getY() + mousePoint.getY()) * zoomChange - mousePoint.getY()));
                    ImageEditorUI.this.myScrollPane.getViewport().setViewPosition(newPosition);
                }
                e.consume();
            }
        }
    }

    private class DocumentChangeListener
    implements ChangeListener {
        private DocumentChangeListener() {
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            if (e == null) {
                DocumentChangeListener.$$$reportNull$$$0(0);
            }
            ImageEditorUI.this.updateImageComponentSize();
            ImageDocument document = ImageEditorUI.this.imageComponent.getDocument();
            BufferedImage value = document.getValue();
            CardLayout layout = (CardLayout)ImageEditorUI.this.contentPanel.getLayout();
            layout.show(ImageEditorUI.this.contentPanel, value != null ? ImageEditorUI.IMAGE_PANEL : ImageEditorUI.ERROR_PANEL);
            ImageEditorUI.this.updateInfo();
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/images/editor/impl/ImageEditorUI$DocumentChangeListener", "stateChanged"));
        }
    }

    private class OptionsChangeListener
    implements PropertyChangeListener {
        private OptionsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Options options = (Options)evt.getSource();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            GridOptions gridOptions = editorOptions.getGridOptions();
            ImageEditorUI.this.imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            ImageEditorUI.this.imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            ImageEditorUI.this.imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            ImageEditorUI.this.imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
            ImageEditorUI.this.imageComponent.setGridLineSpan(gridOptions.getLineSpan());
            ImageEditorUI.this.imageComponent.setGridLineColor(gridOptions.getLineColor());
        }
    }

    private final class ImageContainerPane
    extends JBLayeredPane {
        private final ImageComponent imageComponent;

        ImageContainerPane(final ImageComponent imageComponent) {
            this.imageComponent = imageComponent;
            this.add(imageComponent);
            this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

                public Point magnify(double scale, Point at) {
                    Point locationBefore = imageComponent.getLocation();
                    ImageZoomModel model = ImageEditorUI.this.editor != null ? ImageEditorUI.this.editor.getZoomModel() : ImageEditorUI.this.getZoomModel();
                    double factor = model.getZoomFactor();
                    model.setZoomFactor(scale * factor);
                    return new Point((int)((double)(at.x - Math.max(scale > 1.0 ? locationBefore.x : 0, 0)) * scale), (int)((double)(at.y - Math.max(scale > 1.0 ? locationBefore.y : 0, 0)) * scale));
                }
            });
        }

        private void centerComponents() {
            Rectangle bounds = this.getBounds();
            Point point = this.imageComponent.getLocation();
            point.x = ImageEditorUI.this.isEmbedded ? 0 : (bounds.width - this.imageComponent.getWidth()) / 2;
            point.y = (bounds.height - this.imageComponent.getHeight()) / 2;
            this.imageComponent.setLocation(point);
        }

        public void invalidate() {
            this.centerComponents();
            super.invalidate();
        }

        public Dimension getPreferredSize() {
            return this.imageComponent.getSize();
        }
    }

    private class FocusRequester
    extends MouseAdapter {
        private FocusRequester() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                FocusRequester.$$$reportNull$$$0(0);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)ImageEditorUI.this, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/images/editor/impl/ImageEditorUI$FocusRequester", "mousePressed"));
        }
    }

    private static class ImageTransferable
    implements Transferable {
        private final BufferedImage myImage;

        ImageTransferable(@NotNull BufferedImage image) {
            if (image == null) {
                ImageTransferable.$$$reportNull$$$0(0);
            }
            this.myImage = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!DataFlavor.imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.myImage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ImageEditorUI.IMAGE_PANEL, "org/intellij/images/editor/impl/ImageEditorUI$ImageTransferable", "<init>"));
        }
    }
}

