/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.stash.ui.GitUnstashAsDialog;
import git4idea.ui.StashInfo;
import git4idea.validators.GitBranchValidatorKt;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lgit4idea/stash/ui/GitUnstashAsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "stashInfo", "Lgit4idea/ui/StashInfo;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/StashInfo;)V", "<set-?>", "", "branch", "getBranch", "()Ljava/lang/String;", "branchTextField", "Lcom/intellij/ui/components/JBTextField;", "", "keepIndex", "getKeepIndex", "()Z", "keepIndexCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "popStash", "getPopStash", "popStashCheckbox", "createCenterPanel", "Ljavax/swing/JComponent;", "onBranchChanged", "", "onPopStashChanged", "updateEnabled", "updateOkButtonText", "intellij.vcs.git"})
public final class GitUnstashAsDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final StashInfo stashInfo;
    private JBTextField branchTextField;
    private JBCheckBox popStashCheckbox;
    private JBCheckBox keepIndexCheckbox;
    private boolean popStash;
    private boolean keepIndex;
    @NotNull
    private String branch;

    public GitUnstashAsDialog(@NotNull Project project, @NotNull StashInfo stashInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        super(project);
        this.project = project;
        this.stashInfo = stashInfo;
        this.branch = "";
        Object[] objectArray = new Object[]{this.stashInfo.getRoot().getPresentableName()};
        this.setTitle(GitBundle.message("stash.unstash.changes.in.root.dialog.title", objectArray));
        this.init();
        this.updateOkButtonText();
    }

    public final boolean getPopStash() {
        return this.popStash;
    }

    public final boolean getKeepIndex() {
        return this.keepIndex;
    }

    @NotNull
    public final String getBranch() {
        return this.branch;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GitUnstashAsDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = GitBundle.message("stash.unstash.changes.current.branch.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"stash.unstash.c\u2026es.current.branch.label\")");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GitUnstashAsDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Row $this$row) {
                        Object object;
                        Row row;
                        block3: {
                            block2: {
                                void it;
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                row = $this$row;
                                object = CurrentBranchComponent.Companion.getCurrentBranch(GitUnstashAsDialog.access$getProject$p(this.this$0), GitUnstashAsDialog.access$getStashInfo$p(this.this$0).getRoot());
                                if (object == null) break block2;
                                BranchData branchData = object;
                                Row row2 = row;
                                boolean bl = false;
                                String string = BranchPresentation.INSTANCE.getPresentableText((BranchData)it);
                                row = row2;
                                object = string;
                                if (string != null) break block3;
                            }
                            object = "";
                        }
                        row.label((String)object);
                    }
                });
                String string2 = GitBundle.message("unstash.branch.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"unstash.branch.label\")");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GitUnstashAsDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        GitUnstashAsDialog.access$setBranchTextField$p(this.this$0, (JBTextField)TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                            @Nullable
                            public Object get() {
                                return ((GitUnstashAsDialog)((Object)this.receiver)).getBranch();
                            }

                            public void set(@Nullable Object value) {
                                GitUnstashAsDialog.access$setBranch$p((GitUnstashAsDialog)((Object)this.receiver), (String)value);
                            }
                        })).validationOnInput((Function2)new Function2<ValidationInfoBuilder, JBTextField, ValidationInfo>(this.this$0){
                            final /* synthetic */ GitUnstashAsDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnInput, @NotNull JBTextField it) {
                                Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                String string = it.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                                if (StringsKt.isBlank((CharSequence)string)) {
                                    return null;
                                }
                                GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager(GitUnstashAsDialog.access$getProject$p(this.this$0)).getRepositoryForRootQuick(GitUnstashAsDialog.access$getStashInfo$p(this.this$0).getRoot());
                                if (gitRepository == null) {
                                    return null;
                                }
                                GitRepository repository = gitRepository;
                                Collection collection = CollectionsKt.listOf((Object)repository);
                                String string2 = it.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.text");
                                return GitBranchValidatorKt.validateName(collection, string2);
                            }
                        }).applyToComponent((Function1)new Function1<JBTextField, Unit>(this.this$0){
                            final /* synthetic */ GitUnstashAsDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull JBTextField $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this.this$0){
                                    final /* synthetic */ GitUnstashAsDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    protected void textChanged(@NotNull DocumentEvent e) {
                                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                        GitUnstashAsDialog.access$onBranchChanged(this.this$0);
                                    }
                                });
                            }
                        }).focused().getComponent());
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GitUnstashAsDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = GitBundle.message("unstash.pop.stash", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unstash.pop.stash\")");
                        GitUnstashAsDialog.access$setPopStashCheckbox$p(this.this$0, (JBCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(string).applyToComponent((Function1)new Function1<JBCheckBox, Unit>(this.this$0){
                            final /* synthetic */ GitUnstashAsDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.setToolTipText(GitBundle.message("unstash.pop.stash.tooltip", new Object[0]));
                                $this$applyToComponent.addActionListener(arg_0 -> createCenterPanel.1.invoke$lambda$0(this.this$0, arg_0));
                            }

                            private static final void invoke$lambda$0(GitUnstashAsDialog this$0, ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                                GitUnstashAsDialog.access$onPopStashChanged(this$0);
                            }
                        }), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                            @Nullable
                            public Object get() {
                                return ((GitUnstashAsDialog)((Object)this.receiver)).getPopStash();
                            }

                            public void set(@Nullable Object value) {
                                GitUnstashAsDialog.access$setPopStash$p((GitUnstashAsDialog)((Object)this.receiver), (Boolean)value);
                            }
                        })).getComponent());
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GitUnstashAsDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = GitBundle.message("unstash.reinstate.index", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"unstash.reinstate.index\")");
                        GitUnstashAsDialog.access$setKeepIndexCheckbox$p(this.this$0, (JBCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(string).applyToComponent((Function1)createCenterPanel.1.INSTANCE), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                            @Nullable
                            public Object get() {
                                return ((GitUnstashAsDialog)((Object)this.receiver)).getPopStash();
                            }

                            public void set(@Nullable Object value) {
                                GitUnstashAsDialog.access$setPopStash$p((GitUnstashAsDialog)((Object)this.receiver), (Boolean)value);
                            }
                        })).getComponent());
                    }
                }), (int)1, null);
            }
        }));
    }

    private final void onBranchChanged() {
        this.updateEnabled();
        this.updateOkButtonText();
    }

    private final void onPopStashChanged() {
        this.updateOkButtonText();
    }

    private final void updateEnabled() {
        JBTextField jBTextField = this.branchTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"branchTextField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"branchTextField.text");
        boolean hasBranch = !StringsKt.isBlank((CharSequence)string);
        JBCheckBox jBCheckBox = this.popStashCheckbox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"popStashCheckbox");
            jBCheckBox = null;
        }
        jBCheckBox.setEnabled(!hasBranch);
        JBCheckBox jBCheckBox2 = this.keepIndexCheckbox;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepIndexCheckbox");
            jBCheckBox2 = null;
        }
        jBCheckBox2.setEnabled(!hasBranch);
    }

    private final void updateOkButtonText() {
        String string;
        JBTextField jBTextField = this.branchTextField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"branchTextField");
            jBTextField = null;
        }
        String string2 = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"branchTextField.text");
        if (!StringsKt.isBlank((CharSequence)string2)) {
            string = GitBundle.message("unstash.button.branch", new Object[0]);
        } else {
            JBCheckBox jBCheckBox = this.popStashCheckbox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"popStashCheckbox");
                jBCheckBox = null;
            }
            string = jBCheckBox.isSelected() ? GitBundle.message("unstash.button.pop", new Object[0]) : GitBundle.message("unstash.button.apply", new Object[0]);
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when {\n      branchTextF\u2026tash.button.apply\")\n    }");
        String buttonText = string3;
        this.setOKButtonText(buttonText);
    }

    public static final /* synthetic */ Project access$getProject$p(GitUnstashAsDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ StashInfo access$getStashInfo$p(GitUnstashAsDialog $this) {
        return $this.stashInfo;
    }

    public static final /* synthetic */ void access$setBranchTextField$p(GitUnstashAsDialog $this, JBTextField jBTextField) {
        $this.branchTextField = jBTextField;
    }

    public static final /* synthetic */ void access$setBranch$p(GitUnstashAsDialog $this, String string) {
        $this.branch = string;
    }

    public static final /* synthetic */ void access$onBranchChanged(GitUnstashAsDialog $this) {
        $this.onBranchChanged();
    }

    public static final /* synthetic */ void access$setPopStashCheckbox$p(GitUnstashAsDialog $this, JBCheckBox jBCheckBox) {
        $this.popStashCheckbox = jBCheckBox;
    }

    public static final /* synthetic */ void access$onPopStashChanged(GitUnstashAsDialog $this) {
        $this.onPopStashChanged();
    }

    public static final /* synthetic */ void access$setPopStash$p(GitUnstashAsDialog $this, boolean bl) {
        $this.popStash = bl;
    }

    public static final /* synthetic */ void access$setKeepIndexCheckbox$p(GitUnstashAsDialog $this, JBCheckBox jBCheckBox) {
        $this.keepIndexCheckbox = jBCheckBox;
    }
}

