/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import com.intellij.grazie.text.CommentProblemFilter;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/grazie/text/CommentProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "tokenizer", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "isAboutIdentifierParts", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "text", "Lcom/intellij/grazie/text/TextContent;", "isInFirstSentence", "isTodoComment", "file", "Lcom/intellij/psi/PsiFile;", "shouldIgnore", "textAround", "", "range", "Lcom/intellij/openapi/util/TextRange;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nCommentProblemFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentProblemFilter.kt\ncom/intellij/grazie/text/CommentProblemFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n1747#2,3:63\n12744#3,2:66\n*S KotlinDebug\n*F\n+ 1 CommentProblemFilter.kt\ncom/intellij/grazie/text/CommentProblemFilter\n*L\n51#1:63,3\n59#1:66,2\n*E\n"})
public final class CommentProblemFilter
extends ProblemFilter {
    private final StandardSentenceTokenizer getTokenizer() {
        return StandardSentenceTokenizer.Companion.getDefault();
    }

    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
        TextContent text2 = textContent;
        TextContent.TextDomain domain = text2.getDomain();
        if (domain == TextContent.TextDomain.COMMENTS || domain == TextContent.TextDomain.DOCUMENTATION) {
            PsiFile psiFile = text2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"text.containingFile");
            if (this.isTodoComment(psiFile, text2)) {
                return true;
            }
            String string2 = problem.getRule().getGlobalId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"problem.rule.globalId");
            if (StringsKt.startsWith$default((String)string2, (String)"LanguageTool.", (boolean)false, (int)2, null) && this.isAboutIdentifierParts(problem, text2)) {
                return true;
            }
            if (this.isInFirstSentence(problem) && problem.fitsGroup(new RuleGroup(stringArray = new String[]{"INCOMPLETE_SENTENCE"}))) {
                return true;
            }
        }
        if (domain == TextContent.TextDomain.COMMENTS) {
            stringArray = new String[]{"UNDECORATED_SENTENCE_SEPARATION"};
            if (problem.fitsGroup(new RuleGroup(stringArray))) {
                return true;
            }
            if (Text.isSingleSentence(text2) && problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE)) {
                return true;
            }
        }
        return false;
    }

    private final CharSequence textAround(CharSequence text2, TextRange range) {
        return text2.subSequence(RangesKt.coerceAtLeast((int)(range.getStartOffset() - 20), (int)0), RangesKt.coerceAtMost((int)(range.getEndOffset() + 20), (int)text2.length()));
    }

    private final boolean isInFirstSentence(TextProblem problem) {
        StandardSentenceTokenizer standardSentenceTokenizer = this.getTokenizer();
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
        CharSequence charSequence = textContent;
        int n = 0;
        int n2 = problem.getHighlightRanges().get(0).getStartOffset();
        return standardSentenceTokenizer.tokenize(((Object)charSequence.subSequence(n, n2)).toString()).size() <= 1;
    }

    private final boolean isAboutIdentifierParts(TextProblem problem, TextContent text2) {
        boolean bl;
        block3: {
            List<TextRange> list = problem.getHighlightRanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"problem.highlightRanges");
            List<TextRange> ranges = list;
            Iterable $this$any$iv = ranges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.endsWith$default((CharSequence)text2.subSequence(0, it.getStartOffset()), (char)'_', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text2.subSequence(it.getEndOffset(), text2.length()), (char)'_', (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isTodoComment(PsiFile file2, TextContent text2) {
        boolean bl;
        block1: {
            TodoItem[] todos2 = (TodoItem[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)((PsiElement)file2), arg_0 -> CommentProblemFilter.isTodoComment$lambda$1(isTodoComment.todos.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)todos2, (String)"todos");
            TodoItem[] $this$any$iv = todos2;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                TodoItem element$iv;
                TodoItem it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!text2.intersectsRange(it.getTextRange())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final TodoItem[] isTodoComment$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TodoItem[])$tmp0.invoke(p0);
    }
}

