/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.loomchild.segment.AbstractTextIterator;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.legacy.MergedPattern;
import net.loomchild.segment.srx.legacy.ReaderCharSequence;
import net.loomchild.segment.srx.legacy.ReaderMatcher;
import net.loomchild.segment.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTextIterator
extends AbstractTextIterator {
    private CharSequence text;
    private String segment;
    private MergedPattern mergedPattern;
    private ReaderMatcher breakingMatcher;
    private int startPosition;
    private int endPosition;

    public FastTextIterator(SrxDocument document, String languageCode, CharSequence text2, Map<String, Object> parameterMap) {
        this.text = text2;
        this.segment = null;
        this.startPosition = 0;
        this.endPosition = 0;
        int maxLookbehindConstructLength = Util.getParameter(parameterMap.get("maxLookbehindConstructLength"), 100);
        List<LanguageRule> languageRuleList = document.getLanguageRuleList(languageCode);
        String key2 = "MERGED_PATTERN_" + this.toString(languageRuleList) + "_" + maxLookbehindConstructLength;
        this.mergedPattern = (MergedPattern)document.getCache().get(key2);
        if (this.mergedPattern == null) {
            this.mergedPattern = new MergedPattern(languageRuleList, maxLookbehindConstructLength);
            document.getCache().put(key2, this.mergedPattern);
        }
        if (this.mergedPattern.getBreakingPattern() != null) {
            this.breakingMatcher = new ReaderMatcher(this.mergedPattern.getBreakingPattern(), text2);
        }
    }

    public FastTextIterator(SrxDocument document, String languageCode, CharSequence text2) {
        this(document, languageCode, text2, new HashMap<String, Object>());
    }

    public FastTextIterator(SrxDocument document, String languageCode, Reader reader, Map<String, Object> parameterMap) {
        this(document, languageCode, new ReaderCharSequence(reader, Util.getParameter(parameterMap.get("bufferLength"), 0x100000)), parameterMap);
    }

    public FastTextIterator(SrxDocument document, String languageCode, Reader reader) {
        this(document, languageCode, reader, new HashMap<String, Object>());
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            boolean found = false;
            if (this.breakingMatcher != null) {
                block0: while (!found && this.breakingMatcher.find()) {
                    int breakingRuleIndex = 1;
                    while (this.breakingMatcher.group(breakingRuleIndex) == null) {
                        ++breakingRuleIndex;
                    }
                    this.endPosition = this.breakingMatcher.end(breakingRuleIndex);
                    if (this.endPosition <= this.startPosition) continue;
                    found = true;
                    List<Pattern> activeNonBreakingPatternList = this.mergedPattern.getNonBreakingPatternList(breakingRuleIndex);
                    for (Pattern nonBreakingPattern : activeNonBreakingPatternList) {
                        if (nonBreakingPattern != null) {
                            ReaderMatcher nonBreakingMatcher = new ReaderMatcher(nonBreakingPattern, this.text);
                            nonBreakingMatcher.useTransparentBounds(true);
                            nonBreakingMatcher.region(this.endPosition, this.endPosition);
                            boolean bl = found = !nonBreakingMatcher.lookingAt();
                        }
                        if (found) continue;
                        continue block0;
                    }
                }
                if (found && this.endPosition < this.text.length()) {
                    this.breakingMatcher.region(this.endPosition, this.text.length());
                }
            }
            if (!found) {
                this.endPosition = this.text.length();
            }
            this.segment = this.text.subSequence(this.startPosition, this.endPosition).toString();
            this.startPosition = this.endPosition;
            return this.segment;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.startPosition < this.text.length();
    }
}

