/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.ApiCleanupNeeded;
import org.languagetool.rules.MatchPosition;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.StringTools;

public class RuleMatch
implements Comparable<RuleMatch> {
    public static final RuleMatch[] EMPTY_ARRAY = new RuleMatch[0];
    public static final String SUGGESTION_START_TAG = "<suggestion>";
    public static final String SUGGESTION_END_TAG = "</suggestion>";
    private final Rule rule;
    private final String message;
    private final String shortMessage;
    private final AnalyzedSentence sentence;
    private PatternPosition patternPosition;
    private OffsetPosition offsetPosition;
    private LinePosition linePosition = new LinePosition(-1, -1);
    private ColumnPosition columnPosition = new ColumnPosition(-1, -1);
    private Supplier<List<SuggestedReplacement>> suggestedReplacements;
    private boolean suggestionsComputed = true;
    private URL url;
    private Type type = Type.Other;
    private SortedMap<String, Float> features = Collections.emptySortedMap();
    private boolean autoCorrect = false;
    private String errorLimitLang;
    private String specificRuleId = "";

    public RuleMatch(Rule rule, int fromPos, int toPos, String message) {
        this(rule, fromPos, toPos, message, null, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message) {
        this(rule, sentence, fromPos, toPos, fromPos, toPos, message, null, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message, String shortMessage) {
        this(rule, sentence, fromPos, toPos, fromPos, toPos, message, shortMessage, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, int patternStartPos, int patternEndPos, String message, String shortMessage) {
        this(rule, sentence, fromPos, toPos, patternStartPos, patternEndPos, message, shortMessage, false, null);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, String message, String shortMessage, List<String> suggestions) {
        this(rule, sentence, fromPos, toPos, fromPos, toPos, message, shortMessage, false, null);
        this.setSuggestedReplacements(suggestions);
    }

    public RuleMatch(Rule rule, int fromPos, int toPos, String message, String shortMessage, boolean startWithUppercase, String suggestionsOutMsg) {
        this(rule, null, fromPos, toPos, fromPos, toPos, message, shortMessage, startWithUppercase, suggestionsOutMsg);
    }

    public RuleMatch(Rule rule, AnalyzedSentence sentence, int fromPos, int toPos, int patternFromPos, int patternToPos, String message, String shortMessage, boolean startWithUppercase, String suggestionsOutMsg) {
        int end;
        this.rule = Objects.requireNonNull(rule);
        if (toPos <= fromPos) {
            throw new IllegalArgumentException("fromPos (" + fromPos + ") must be less than toPos (" + toPos + ")");
        }
        this.patternPosition = new PatternPosition(patternFromPos, patternToPos);
        this.offsetPosition = new OffsetPosition(fromPos, toPos);
        this.message = Objects.requireNonNull(message);
        this.shortMessage = shortMessage;
        LinkedHashSet<SuggestedReplacement> replacements = new LinkedHashSet<SuggestedReplacement>();
        String suggestion = message + (suggestionsOutMsg != null ? suggestionsOutMsg : "");
        int pos = suggestion.indexOf(SUGGESTION_START_TAG);
        while (pos != -1 && (end = suggestion.indexOf(SUGGESTION_END_TAG, pos)) != -1) {
            String replacement = suggestion.substring(pos + SUGGESTION_START_TAG.length(), end);
            pos = end + SUGGESTION_END_TAG.length();
            if (replacement.contains("<mistake/>")) continue;
            if (startWithUppercase) {
                replacement = StringTools.uppercaseFirstChar(replacement);
            }
            replacements.add(new SuggestedReplacement(replacement));
            pos = suggestion.indexOf(SUGGESTION_START_TAG, pos);
        }
        this.sentence = sentence;
        this.suggestedReplacements = Suppliers.ofInstance(new ArrayList(replacements));
    }

    public RuleMatch(RuleMatch clone) {
        this(clone.getRule(), clone.getSentence(), clone.getFromPos(), clone.getToPos(), clone.getMessage(), clone.getShortMessage());
        this.setPatternPosition(clone.getPatternFromPos(), clone.getPatternToPos());
        this.suggestedReplacements = clone.suggestedReplacements;
        this.setAutoCorrect(clone.isAutoCorrect());
        this.setFeatures(clone.getFeatures());
        this.setUrl(clone.getUrl());
        this.setType(clone.getType());
        this.setLine(clone.getLine());
        this.setEndLine(clone.getEndLine());
        this.setColumn(clone.getColumn());
        this.setEndColumn(clone.getEndColumn());
        this.setSpecificRuleId(clone.getSpecificRuleId());
    }

    public RuleMatch(RuleMatch clone, List<SuggestedReplacement> replacements, boolean ignored) {
        this(clone.getRule(), clone.getSentence(), clone.getFromPos(), clone.getToPos(), clone.getMessage(), clone.getShortMessage());
        this.setPatternPosition(clone.getPatternFromPos(), clone.getPatternToPos());
        this.setSuggestedReplacementObjects(replacements);
        this.setAutoCorrect(clone.isAutoCorrect());
        this.setFeatures(clone.getFeatures());
        this.setUrl(clone.getUrl());
        this.setType(clone.getType());
        this.setLine(clone.getLine());
        this.setEndLine(clone.getEndLine());
        this.setColumn(clone.getColumn());
        this.setEndColumn(clone.getEndColumn());
        this.setSpecificRuleId(clone.getSpecificRuleId());
    }

    public RuleMatch(RuleMatch clone, List<SuggestedReplacement> replacements) {
        this(clone, replacements, false);
    }

    @NotNull
    public SortedMap<String, Float> getFeatures() {
        return this.features;
    }

    public void setFeatures(@NotNull SortedMap<String, Float> features) {
        this.features = features;
    }

    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    public void setAutoCorrect(boolean autoCorrect) {
        this.autoCorrect = autoCorrect;
    }

    public Rule getRule() {
        return this.rule;
    }

    public int getLine() {
        return this.linePosition.getStart();
    }

    public void setLine(int fromLine) {
        this.linePosition = new LinePosition(fromLine, this.linePosition.getEnd());
    }

    public int getEndLine() {
        return this.linePosition.getEnd();
    }

    public void setEndLine(int endLine) {
        this.linePosition = new LinePosition(this.linePosition.getStart(), endLine);
    }

    public int getColumn() {
        return this.columnPosition.getStart();
    }

    public void setColumn(int column) {
        this.columnPosition = new ColumnPosition(column, this.columnPosition.getEnd());
    }

    public int getEndColumn() {
        return this.columnPosition.getEnd();
    }

    public void setEndColumn(int endColumn) {
        this.columnPosition = new ColumnPosition(this.columnPosition.getStart(), endColumn);
    }

    public int getPatternFromPos() {
        return this.patternPosition.getStart();
    }

    public int getPatternToPos() {
        return this.patternPosition.getEnd();
    }

    public void setPatternPosition(int fromPos, int toPos) {
        if (toPos <= fromPos) {
            throw new RuntimeException("fromPos (" + fromPos + ") must be less than toPos (" + toPos + ")");
        }
        this.patternPosition = new PatternPosition(fromPos, toPos);
    }

    public int getFromPos() {
        return this.offsetPosition.getStart();
    }

    public int getToPos() {
        return this.offsetPosition.getEnd();
    }

    public void setOffsetPosition(int fromPos, int toPos) {
        if (toPos <= fromPos) {
            throw new RuntimeException("fromPos (" + fromPos + ") must be less than toPos (" + toPos + ") for match: <sentcontent>" + this + "</sentcontent>");
        }
        this.offsetPosition = new OffsetPosition(fromPos, toPos);
    }

    public String getMessage() {
        return this.message;
    }

    @ApiCleanupNeeded(value="Should return an Optional")
    public String getShortMessage() {
        if (this.shortMessage == null) {
            return "";
        }
        return this.shortMessage;
    }

    public void setSuggestedReplacement(String replacement) {
        Objects.requireNonNull(replacement, "replacement may be empty but not null");
        ArrayList<String> replacements = new ArrayList<String>();
        replacements.add(replacement);
        this.setSuggestedReplacements(replacements);
    }

    public void addSuggestedReplacement(String replacement) {
        Objects.requireNonNull(replacement, "replacement may be empty but not null");
        this.addSuggestedReplacements(Collections.singletonList(replacement));
    }

    public void addSuggestedReplacements(List<String> replacements) {
        Objects.requireNonNull(replacements, "replacements may be empty but not null");
        Supplier<List<SuggestedReplacement>> prev = this.suggestedReplacements;
        this.setLazySuggestedReplacements(() -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)((Iterable)prev.get()), (Iterable)Iterables.transform((Iterable)replacements, SuggestedReplacement::new))));
    }

    public List<String> getSuggestedReplacements() {
        return Collections.unmodifiableList(this.suggestedReplacements.get().stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList()));
    }

    public void setSuggestedReplacements(List<String> replacements) {
        Objects.requireNonNull(replacements, "replacements may be empty but not null");
        this.suggestionsComputed = true;
        this.suggestedReplacements = Suppliers.ofInstance(replacements.stream().map(SuggestedReplacement::new).collect(Collectors.toList()));
    }

    public List<SuggestedReplacement> getSuggestedReplacementObjects() {
        return Collections.unmodifiableList(this.suggestedReplacements.get());
    }

    public void setSuggestedReplacementObjects(List<SuggestedReplacement> replacements) {
        Objects.requireNonNull(replacements, "replacements may be empty but not null");
        this.suggestedReplacements = Suppliers.ofInstance(replacements);
        this.suggestionsComputed = true;
    }

    public void setLazySuggestedReplacements(@NotNull Supplier<List<SuggestedReplacement>> replacements) {
        Objects.requireNonNull(replacements, "replacements may not be null");
        this.suggestedReplacements = Suppliers.memoize(replacements::get);
        this.suggestionsComputed = false;
    }

    public void computeLazySuggestedReplacements() {
        this.suggestedReplacements = Suppliers.ofInstance(this.suggestedReplacements.get());
        this.suggestionsComputed = true;
    }

    public void discardLazySuggestedReplacements() {
        if (!this.suggestionsComputed) {
            this.setSuggestedReplacementObjects(Collections.emptyList());
        }
    }

    @Nullable
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url2) {
        this.url = url2;
    }

    public AnalyzedSentence getSentence() {
        return this.sentence;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public String toString() {
        if (this.rule instanceof PatternRule) {
            return this.rule.getFullId() + ":" + this.offsetPosition + ":" + this.message;
        }
        return this.rule.getId() + ":" + this.offsetPosition + ":" + this.message;
    }

    @Override
    public int compareTo(RuleMatch other) {
        Objects.requireNonNull(other);
        return Integer.compare(this.getFromPos(), other.getFromPos());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleMatch other = (RuleMatch)o;
        return Objects.equals(this.rule.getId(), other.rule.getId()) && Objects.equals(this.patternPosition, other.patternPosition) && Objects.equals(this.offsetPosition, other.offsetPosition) && Objects.equals(this.message, other.message) && Objects.equals(this.sentence, other.sentence) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rule.getId(), this.offsetPosition, this.patternPosition, this.message, this.sentence, this.type});
    }

    @Nullable
    public String getErrorLimitLang() {
        return this.errorLimitLang;
    }

    public void setErrorLimitLang(String langCode) {
        this.errorLimitLang = langCode;
    }

    public void setSpecificRuleId(String ruleId) {
        this.specificRuleId = ruleId;
    }

    public String getSpecificRuleId() {
        if (this.specificRuleId.isEmpty()) {
            return this.getRule().getId();
        }
        return this.specificRuleId;
    }

    static class ColumnPosition
    extends MatchPosition {
        ColumnPosition(int start, int end) {
            super(start, end);
        }
    }

    static class LinePosition
    extends MatchPosition {
        LinePosition(int start, int end) {
            super(start, end);
        }
    }

    static class OffsetPosition
    extends MatchPosition {
        OffsetPosition(int start, int end) {
            super(start, end);
        }
    }

    static class PatternPosition
    extends MatchPosition {
        PatternPosition(int start, int end) {
            super(start, end);
        }
    }

    public static enum Type {
        UnknownWord,
        Hint,
        Other;

    }
}

