/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLFileType;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.ruby.psi.HAMLRubyFile;
import org.jetbrains.plugins.haml.ruby.psi.HAMLRubyUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.templates.TemplateIntegration;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public class RubyHAMLIntegrationImpl
implements TemplateIntegration {
    private static final List<IElementType> OUTER_ELEMENTS = Arrays.asList(HAMLTokenTypes.HAML_INJECTION_IN_RUBY, HAMLTokenTypes.RUBY_CODE_MARKER, HAMLTokenTypes.LINE_CONTINUATION, HAMLTokenTypes.EOL);
    private static final Set<IElementType> CONTINUATION_ELEMENTS = Collections.singleton(HAMLTokenTypes.LINE_CONTINUATION);
    private static final Set<IElementType> END_ELEMENTS = Collections.singleton(RubyTokenTypes.kEND);

    @NotNull
    public Collection<? extends IElementType> getOuterElements() {
        List<IElementType> list = OUTER_ELEMENTS;
        if (list == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public Collection<? extends IElementType> getContinuationElements() {
        Set<IElementType> set = CONTINUATION_ELEMENTS;
        if (set == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Collection<? extends IElementType> getEndElements() {
        Set<IElementType> set = END_ELEMENTS;
        if (set == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isTemplateFile(@Nullable PsiFile file) {
        return file instanceof HAMLRubyFile;
    }

    public boolean shouldNotInspectHash(RAssocList list) {
        return list.getContainingFile() instanceof HAMLRubyFile;
    }

    public boolean canModifyPsiInsert(@NotNull FileViewProvider provider) {
        if (provider == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(3);
        }
        Set languages = provider.getLanguages();
        PsiFile hamlPsiFile = provider.getPsi((Language)HAMLLanguage.INSTANCE);
        return languages.size() == 2 && hamlPsiFile != null;
    }

    @Nullable
    public PsiElement addRubyStatement(@NotNull FileViewProvider provider, @NotNull RCompoundStatement parent, @NotNull PsiElement elementToAdd, @Nullable PsiElement anchor, boolean before) {
        if (provider == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(5);
        }
        if (elementToAdd == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(6);
        }
        return HAMLRubyUtil.addRubyStatement(parent, elementToAdd, anchor, before);
    }

    @Nullable
    public FileType getFileType(@NotNull TemplateIntegrationUtils.TemplateLang lang) {
        if (lang == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(7);
        }
        return lang == this.getTemplateLanguage() ? this.getFileType() : null;
    }

    @NotNull
    public TemplateIntegrationUtils.TemplateLang getTemplateLanguage() {
        TemplateIntegrationUtils.TemplateLang templateLang = TemplateIntegrationUtils.TemplateLang.HAML;
        if (templateLang == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(8);
        }
        return templateLang;
    }

    @NotNull
    public FileType getFileType() {
        HAMLFileType hAMLFileType = HAMLFileType.HAML;
        if (hAMLFileType == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(9);
        }
        return hAMLFileType;
    }

    @NotNull
    public Language getLanguage() {
        HAMLLanguage hAMLLanguage = HAMLLanguage.INSTANCE;
        if (hAMLLanguage == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(10);
        }
        return hAMLLanguage;
    }

    @Nullable
    public String getTextForI18n(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(11);
        }
        if (file == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(12);
        }
        return (String)ObjectUtils.doIfNotNull((Object)RubyHAMLIntegrationImpl.findTextElementAtCaret(editor, file), element -> element.getText().trim());
    }

    public boolean replaceTextWithI18n(@NotNull Editor editor, @NotNull PsiFile file, @NotNull RExpression expression) {
        PsiElement element;
        if (editor == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(13);
        }
        if (file == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(15);
        }
        if ((element = RubyHAMLIntegrationImpl.findTextElementAtCaret(editor, file)) == null) {
            return false;
        }
        PsiElement firstElement = element;
        while (RubyHAMLIntegrationImpl.isWhiteSpaceOrEolOrLineContinuation(firstElement.getPrevSibling())) {
            firstElement = firstElement.getPrevSibling();
        }
        Document document = editor.getDocument();
        int startOffset = firstElement.getTextRange().getStartOffset();
        int endOffset = element.getTextRange().getEndOffset();
        document.replaceString(startOffset, endOffset, (CharSequence)("= " + expression.getText()));
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        return true;
    }

    public boolean mustCloseRubyBlock() {
        return false;
    }

    private static boolean isWhiteSpaceOrEolOrLineContinuation(@Nullable PsiElement sign) {
        return HAMLTokenTypes.SPACES.contains(PsiUtilCore.getElementType((PsiElement)sign));
    }

    @Nullable
    private static PsiElement findTextElementAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        if (editor == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(16);
        }
        if (file == null) {
            RubyHAMLIntegrationImpl.$$$reportNull$$$0(17);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null || PsiUtilCore.getElementType((PsiElement)element) != HAMLTokenTypes.TEXT) {
            return null;
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/haml/RubyHAMLIntegrationImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAdd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContinuationElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/haml/RubyHAMLIntegrationImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canModifyPsiInsert";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRubyStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTextForI18n";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceTextWithI18n";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findTextElementAtCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

