/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryRuntimeTask {
    private volatile String mySuccessMessage;
    private volatile ServerRuntimeException myError;

    public void performAsyncWithNotification(@Nullable Project project, ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, String title, String defaultSuccessMessage) {
        CloudNotifier notifier = new CloudNotifier(DockerCloudType.getInstance().getPresentableName());
        this.doPerform(taskExecutor, agentTaskExecutor, defaultSuccessMessage, (Consumer<Progressive>)((Consumer)progressive -> new Task.Backgroundable(project, title, true, PerformInBackgroundOption.DEAF, (Progressive)progressive, notifier){
            final /* synthetic */ Progressive val$progressive;
            final /* synthetic */ CloudNotifier val$notifier;
            {
                this.val$progressive = progressive;
                this.val$notifier = cloudNotifier;
                super(arg0, arg1, arg2, arg3);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.val$progressive.run(indicator);
                if (RegistryRuntimeTask.this.myError != null) {
                    this.val$notifier.showMessage(RegistryRuntimeTask.this.myError.getMessage(), MessageType.ERROR);
                } else {
                    this.val$notifier.showMessage(RegistryRuntimeTask.this.mySuccessMessage, MessageType.INFO);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/registry/RegistryRuntimeTask$1", "run"));
            }
        }.queue()));
    }

    public void performSync(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, String title) throws ServerRuntimeException {
        this.doPerform(taskExecutor, agentTaskExecutor, null, (Consumer<Progressive>)((Consumer)progressive -> {
            Task.Modal task = new Task.Modal(null, title, true, (Progressive)progressive){
                final /* synthetic */ Progressive val$progressive;
                {
                    this.val$progressive = progressive;
                    super(arg0, arg1, arg2);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.val$progressive.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/registry/RegistryRuntimeTask$2", "run"));
                }
            };
            if (!ProgressManager.getInstance().hasProgressIndicator()) {
                UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task));
            } else {
                task.run(ProgressManager.getInstance().getProgressIndicator());
            }
        }));
        if (this.myError != null) {
            throw this.myError;
        }
    }

    private void doPerform(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, String defaultSuccessMessage, Consumer<Progressive> taskRunner) {
        this.mySuccessMessage = defaultSuccessMessage;
        final AtomicReference<Object> indicatorRef = new AtomicReference<Object>(null);
        AtomicReference<Object> processRef = new AtomicReference<Object>(null);
        Semaphore processSemaphore = new Semaphore();
        processSemaphore.down();
        taskExecutor.submit(() -> {
            try {
                OngoingProcess ongoingProcess = (OngoingProcess)agentTaskExecutor.execute(() -> this.doPerform(new DockerAgentProgressCallback(){

                    public void step(String status, long current, long total) {
                        ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                        if (indicator == null) {
                            return;
                        }
                        indicator.setText2(status + (total == 0L ? "" : " " + RegistryRuntimeTask.formatFraction(current, total)));
                        boolean indeterminate = total == 0L;
                        indicator.setIndeterminate(indeterminate);
                        if (!indeterminate) {
                            indicator.setFraction((double)current / (double)total);
                        }
                    }

                    public void succeeded(String message) {
                        try {
                            RegistryRuntimeTask.this.succeeded();
                        }
                        finally {
                            if (message != null) {
                                RegistryRuntimeTask.this.mySuccessMessage = message;
                            }
                        }
                    }

                    public void failed(String message) {
                        RegistryRuntimeTask.this.myError = new ServerRuntimeException(message);
                    }
                }));
                processRef.set(ongoingProcess);
            }
            catch (ServerRuntimeException e) {
                this.myError = e;
            }
            finally {
                processSemaphore.up();
            }
        });
        taskRunner.consume(indicator -> {
            indicatorRef.set(indicator);
            indicator.setIndeterminate(true);
            processSemaphore.waitFor();
            final OngoingProcess ongoingProcess = (OngoingProcess)processRef.get();
            if (ongoingProcess != null) {
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                        public void cancel() {
                            ongoingProcess.cancel();
                        }
                    });
                }
                ongoingProcess.await();
            }
        });
    }

    protected void succeeded() {
    }

    protected abstract OngoingProcess doPerform(DockerAgentProgressCallback var1);

    @NotNull
    private static String formatFraction(long current, long total) {
        String string = RegistryRuntimeTask.formatSize(current) + " of " + RegistryRuntimeTask.formatSize(total);
        if (string == null) {
            RegistryRuntimeTask.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String formatSize(long size) {
        int kilo = 1024;
        if (size < 1024L) {
            String string = size + " bytes";
            if (string == null) {
                RegistryRuntimeTask.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (size < 0x100000L) {
            String string = String.format(Locale.US, "%.1f kB", (double)size / 1024.0);
            if (string == null) {
                RegistryRuntimeTask.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = String.format(Locale.US, "%.1f MB", (double)size / 1048576.0);
        if (string == null) {
            RegistryRuntimeTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/docker/registry/RegistryRuntimeTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFraction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSize";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

