/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.derby.model.DerbyModRoutine;
import com.intellij.database.dialects.generic.introspector.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.generic.introspector.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSpecificRoutine;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericIntrospectorHelper {
    private final BasicModModel myModel;
    private final Dbms myDbms;
    private final boolean mySchemaDbMode;
    private final Map<BasicModElement, String> myProcSpecNames;

    public GenericIntrospectorHelper(@NotNull BasicModModel model, @NotNull Dbms dbms) {
        if (model == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(0);
        }
        if (dbms == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(1);
        }
        this.myProcSpecNames = ContainerUtil.newHashMap();
        this.myModel = model;
        this.myDbms = dbms;
        this.mySchemaDbMode = DbImplUtil.isSchemaDbMode(this.myModel, this.myDbms);
    }

    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myModel;
        if (basicModModel == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(2);
        }
        return basicModModel;
    }

    @Nullable
    public BasicModNamespace getDatabase(@NotNull BasicModSchema schema) {
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(3);
        }
        if (this.mySchemaDbMode) {
            return schema;
        }
        BasicNamespaceOwner parent2 = schema.getParent();
        return parent2 != null && parent2.getKind() == ObjectKind.DATABASE ? (BasicModNamespace)((Object)parent2) : null;
    }

    @NotNull
    public DatabaseMetaDataWrapper.Schema asSchema(@NotNull BasicModSchema schema) {
        BasicModNamespace database;
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(4);
        }
        String databaseName = (database = this.getDatabase(schema)) == null ? null : database.getName();
        DatabaseMetaDataWrapper.Schema schema2 = this.mySchemaDbMode ? new DatabaseMetaDataWrapper.Schema(StringUtil.notNullize((String)databaseName), StringUtil.nullize((String)schema.getName())) : new DatabaseMetaDataWrapper.Schema(schema.getName(), databaseName);
        if (schema2 == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(5);
        }
        return schema2;
    }

    @NotNull
    public DatabaseMetaDataWrapper.Table asTable(@NotNull BasicModTableOrView table) {
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(6);
        }
        BasicElement parent2 = table.getParent();
        assert (parent2 != null) : "The table " + table.getName() + " has no parent";
        DatabaseMetaDataWrapper.Table table2 = new DatabaseMetaDataWrapper.Table(this.asSchema((BasicModSchema)parent2), table.getName());
        if (table2 == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(7);
        }
        return table2;
    }

    public void createTable(@NotNull BasicModSchema schema, @NotNull DatabaseMetaDataWrapper.Table table) {
        ObjectKind kind;
        ModNamingFamily tables;
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(8);
        }
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(9);
        }
        if ((tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, kind = JdbcTableType.findByName(table.type).getKind())) == null && kind != ObjectKind.INDEX) {
            tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.TABLE);
        }
        if (tables == null) {
            return;
        }
        Object res2 = tables.createOrGet(table.name);
        String comment = StringUtil.nullize((String)table.comment);
        if (this.myDbms.isMysql() && kind == ObjectKind.VIEW && "VIEW".equals(comment)) {
            comment = null;
        }
        res2.setComment(comment);
    }

    public void createKeys(@NotNull BasicModTableOrView table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt) {
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(10);
        }
        if (keyIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(11);
        }
        DatabaseMetaDataWrapper.TableKey storedKey = new DatabaseMetaDataWrapper.TableKey(this.asTable(table), null);
        for (DatabaseMetaDataWrapper.TableKey key2 : JBIterable.once(keyIt)) {
            storedKey.assign(key2);
            this.createKey(table, key2, (Iterator<DatabaseMetaDataWrapper.TableKeyColumn>)keyIt.groupIt());
        }
    }

    public void createKey(@NotNull BasicModTableOrView table, @NotNull DatabaseMetaDataWrapper.TableKey key2, @NotNull Iterator<DatabaseMetaDataWrapper.TableKeyColumn> keyColumnIt) {
        ModNamingFamily keys;
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(12);
        }
        if (key2 == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(13);
        }
        if (keyColumnIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(14);
        }
        if ((keys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.KEY)) == null) {
            return;
        }
        BasicModKey res2 = (BasicModKey)keys.createOrGet(StringUtil.notNullize((String)key2.name));
        TreeMap columns = ContainerUtil.newTreeMap();
        res2.setPrimary(key2.primary);
        for (DatabaseMetaDataWrapper.TableKeyColumn col : JBIterable.once(keyColumnIt)) {
            columns.put(col.position, col.name);
        }
        res2.setColNames(ArrayUtil.toStringArray(columns.values()));
        res2.setNameSurrogate(this.isSurrogate(key2));
    }

    public void createRoutine(@NotNull BasicModSchema schema, @NotNull DatabaseMetaDataWrapper.Routine routine) {
        String pkg;
        BasicModSchema parent2;
        ModNamingFamily routines;
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(15);
        }
        if (routine == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(16);
        }
        if ((routines = GenericIntrospectorLegacyModelUtils.familyOf(parent2 = (pkg = this.getRealPackage(routine)) == null ? schema : GenericIntrospectorHelper.getOrCreatePackage(schema, pkg), ObjectKind.ROUTINE)) == null) {
            return;
        }
        Object procedure = this.getOrCreateRoutineBySpecName(routines, routine.name, routine.specificName);
        if (procedure instanceof BasicModArrangedElement) {
            ((BasicModArrangedElement)procedure).setPosition(routine.number);
        }
        ((BasicModRoutine)procedure).setRoutineKind(routine.kind);
        String comment = StringUtil.nullize((String)routine.comment);
        if (this.myDbms.isOracle()) {
            if (procedure.getParent() == schema && comment != null && comment.startsWith("Standalone")) {
                comment = null;
            }
        } else if (this.myDbms.isDerby()) {
            if (procedure instanceof DerbyModRoutine) {
                ((DerbyModRoutine)procedure).setExternalName(comment);
            }
            comment = null;
        }
        procedure.setComment(comment);
    }

    public void createType(@NotNull BasicModSchema schema, @NotNull DatabaseMetaDataWrapper.Type type, @NotNull ObjectKind kind) {
        ModNamingFamily types;
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(17);
        }
        if (type == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(18);
        }
        if (kind == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(19);
        }
        if ((types = GenericIntrospectorHelper.needed(GenericIntrospectorLegacyModelUtils.familyOf(schema, kind))) == null) {
            return;
        }
        types.createOrGet(StringUtil.notNullize((String)type.name));
    }

    public void createUserDefinedType(@NotNull BasicModSchema schema, @NotNull DatabaseMetaDataWrapper.UserDefinedType userDefinedType) {
        ModNamingFamily userDefinedTypes;
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(20);
        }
        if (userDefinedType == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(21);
        }
        if ((userDefinedTypes = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.OBJECT_TYPE)) == null) {
            userDefinedTypes = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.TABLE_TYPE);
        }
        if (userDefinedTypes == null) {
            userDefinedTypes = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.ALIAS_TYPE);
        }
        if (userDefinedTypes == null) {
            userDefinedTypes = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.COLLECTION_TYPE);
        }
        GenericIntrospectorHelper.needed(userDefinedTypes);
        if (userDefinedTypes == null || GenericIntrospectorHelper.noNeedToShow(schema, userDefinedType)) {
            return;
        }
        Object res2 = userDefinedTypes.createOrGet(StringUtil.notNullize((String)userDefinedType.name));
        res2.setComment(StringUtil.nullize((String)userDefinedType.comment));
    }

    public void createUserDefinedTypeAttributes(@Nullable BasicModElement userDefinedType, @NotNull Iterator<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> attrIt) {
        if (attrIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(22);
        }
        if (userDefinedType == null) {
            return;
        }
        ModNamingFamily attrs = GenericIntrospectorHelper.needed(GenericIntrospectorLegacyModelUtils.familyOf(userDefinedType, ObjectKind.OBJECT_ATTRIBUTE));
        if (attrs == null) {
            return;
        }
        for (DatabaseMetaDataWrapper.UserDefinedTypeAttribute attr : JBIterable.once(attrIt)) {
            this.createUserDefinedTypeAttribute(attrs, attr);
        }
    }

    public void createUserDefinedTypeAttribute(@NotNull ModNamingFamily<?> attrs, @NotNull DatabaseMetaDataWrapper.UserDefinedTypeAttribute attr) {
        BasicModTypedElement typed;
        if (attrs == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(23);
        }
        if (attr == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(24);
        }
        Object attribute = attrs.createOrGet(StringUtil.notNullize((String)attr.name));
        attribute.setComment(StringUtil.nullize((String)attr.comment));
        if (attribute instanceof BasicModArrangedElement) {
            ((BasicModArrangedElement)attribute).setPosition((short)attr.position);
        }
        if ((typed = (BasicModTypedElement)ObjectUtils.tryCast(attribute, BasicModTypedElement.class)) != null) {
            typed.setDataType(GenericIntrospectorHelper.makeDataType(StringUtil.notNullize((String)attr.typeName), attr.length, attr.scale, null, attr.type));
            typed.setNotNull(!attr.nullable);
            typed.setDefaultExpression(GenericIntrospectorLegacyModelUtils.fixDefaultValue(this.myDbms, typed, attr.def));
        }
    }

    private static boolean noNeedToShow(@NotNull BasicModSchema schema, @NotNull DatabaseMetaDataWrapper.UserDefinedType userDefinedType) {
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(25);
        }
        if (userDefinedType == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(26);
        }
        ModNamingFamily seqs = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.SEQUENCE);
        return userDefinedType.name == null || schema.getTableOrView(userDefinedType.name) != null || seqs != null && seqs.get(userDefinedType.name) != null;
    }

    public void createColumns(@Nullable BasicModTableOrView table, @NotNull Iterator<DatabaseMetaDataWrapper.TableColumn> columnIt) {
        if (columnIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(27);
        }
        if (table == null) {
            return;
        }
        for (DatabaseMetaDataWrapper.TableColumn column2 : JBIterable.once(columnIt)) {
            this.createColumn(table, column2);
        }
    }

    public void createColumn(@NotNull BasicModTableOrView table, @NotNull DatabaseMetaDataWrapper.TableColumn col) {
        ModNamingFamily columns;
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(28);
        }
        if (col == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(29);
        }
        if ((columns = GenericIntrospectorHelper.needed(GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.COLUMN))) == null) {
            return;
        }
        String typeName = StringUtil.notNullize((String)col.typeName);
        DataType dataType = GenericIntrospectorHelper.makeDataType(typeName, col.length, col.scale, col.typeSuffix, col.type);
        BasicModTableOrViewColumn column2 = (BasicModTableOrViewColumn)columns.createOrGet(StringUtil.notNullize((String)col.name));
        column2.setPosition((short)col.position);
        column2.setDataType(dataType);
        column2.setNotNull(!col.nullable);
        column2.setDefaultExpression(GenericIntrospectorLegacyModelUtils.fixDefaultValue(this.myDbms, column2, col.def));
        column2.setComment(StringUtil.nullize((String)col.comment));
        if (column2 instanceof BasicModTableColumn) {
            BasicModTableColumn tColumn = (BasicModTableColumn)column2;
            tColumn.setSequenceIdentity(col.autoIncrement ? SequenceIdentity.UNKNOWN : null);
        }
    }

    public void createSchema(@NotNull DatabaseMetaDataWrapper.Schema schema) {
        BasicModDatabase db;
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(30);
        }
        if ((db = this.createDatabase(schema.database)) != null) {
            db.getSchemas().createOrGet(schema.schema);
            return;
        }
        ModNamingFamily schemaFamily = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.myModel.getRoot()), ObjectKind.SCHEMA);
        if (schemaFamily == null) {
            return;
        }
        String name = this.mySchemaDbMode ? StringUtil.notNullize((String)schema.database) : schema.schema;
        schemaFamily.createOrGet(name);
    }

    @Nullable
    public BasicModDatabase createDatabase(@Nullable String database) {
        ModNamingFamily<BasicModNamedElement> dbFamily = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.myModel.getRoot()), ObjectKind.DATABASE);
        if (dbFamily == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)database)) {
            BasicModDatabase res2 = null;
            for (BasicModNamedElement db : dbFamily) {
                if (db.isSyncPending()) continue;
                if (res2 != null) {
                    res2 = null;
                    break;
                }
                res2 = (BasicModDatabase)((Object)db);
            }
            if (res2 != null) {
                return res2;
            }
        }
        return (BasicModDatabase)((Object)dbFamily.createOrGet(StringUtil.notNullize((String)database)));
    }

    public void createIndices(@NotNull BasicModTableOrView table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt) {
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(31);
        }
        if (indexColumnIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(32);
        }
        BasicElement parent2 = table.getParent();
        assert (parent2 != null) : "Table " + table.getName() + " has no parent";
        DatabaseMetaDataWrapper.TableIndex storedIdx = new DatabaseMetaDataWrapper.TableIndex(new DatabaseMetaDataWrapper.Table(this.asSchema((BasicModSchema)parent2), table.getName()), "");
        for (DatabaseMetaDataWrapper.TableIndex idx : JBIterable.once(indexColumnIt)) {
            storedIdx.assign(idx);
            this.createIndex(table, storedIdx, (Iterator<DatabaseMetaDataWrapper.TableIndexColumn>)indexColumnIt.groupIt());
        }
    }

    private void createIndex(@NotNull BasicModTableOrView table, @NotNull DatabaseMetaDataWrapper.TableIndex idx, @NotNull Iterator<DatabaseMetaDataWrapper.TableIndexColumn> columnIt) {
        ModNamingFamily indices;
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(33);
        }
        if (idx == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(34);
        }
        if (columnIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(35);
        }
        if ((indices = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.INDEX)) == null) {
            return;
        }
        TreeMap columns = ContainerUtil.newTreeMap();
        LinkedHashSet rev = ContainerUtil.newLinkedHashSet();
        for (DatabaseMetaDataWrapper.TableIndexColumn column2 : JBIterable.once(columnIt)) {
            String colName = StringUtil.notNullize((String)column2.name);
            columns.put(column2.position, colName);
            if (column2.sorting != DasIndex.Sorting.DESCENDING) continue;
            rev.add(colName);
        }
        BasicModIndex index2 = (BasicModIndex)indices.createOrGet(StringUtil.notNullize((String)idx.name));
        index2.setUnique(!idx.nonUnique);
        index2.setColNames(ContainerUtil.newArrayList(columns.values()));
        index2.setReverseColNames(rev);
        index2.setNameSurrogate(this.isSurrogate(idx));
        if ((index2.isUnique() || this.myDbms.isDerby() && index2.isNameSurrogate()) && (!this.myDbms.isDb2() || index2.isNameSurrogate())) {
            BasicForeignKey fk;
            BasicModKey key2;
            List<String> names = index2.getColNames();
            ModNamingFamily keys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.KEY);
            BasicModKey basicModKey = key2 = keys == null ? null : keys.find(k -> !k.isSyncPending() && k.getColNames().equals(names));
            if (key2 == null && !index2.isUnique() && this.myDbms.isDerby() && (fk = table.getForeignKeys().find(f -> !((BasicModForeignKey)f).isSyncPending() && names.equals(f.getColNames()))) != null) {
                keys = null;
            }
            if (keys != null && key2 == null) {
                key2 = keys.find(k -> k.isSyncPending() && k.getColNames().equals(names));
                if (key2 == null) {
                    key2 = (BasicModKey)keys.createNewOne();
                } else {
                    key2.resetSyncPending();
                }
                if (this.myDbms.isDb2()) {
                    key2.setRealName(null);
                    key2.setNameSurrogate(true);
                } else {
                    key2.setName(index2.getName());
                    key2.setNameSurrogate(index2.isNameSurrogate());
                }
                key2.setPrimary(false);
                key2.setColNames(names);
            }
        }
    }

    public void createForeignKeys(@NotNull BasicModTableOrView table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt) {
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(36);
        }
        if (fkColumnIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(37);
        }
        DatabaseMetaDataWrapper.TableFKey storedFkey = new DatabaseMetaDataWrapper.TableFKey(new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), "");
        for (DatabaseMetaDataWrapper.TableFKey fkey : JBIterable.once(fkColumnIt)) {
            storedFkey.assign(fkey);
            this.createForeignKey(table, fkey, (Iterator<DatabaseMetaDataWrapper.TableFKeyColumn>)fkColumnIt.groupIt());
        }
    }

    public void createForeignKey(@NotNull BasicModTableOrView table, @NotNull DatabaseMetaDataWrapper.TableFKey key2, @NotNull Iterator<DatabaseMetaDataWrapper.TableFKeyColumn> columnIt) {
        ModNamingFamily foreignKeys;
        if (table == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(38);
        }
        if (key2 == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(39);
        }
        if (columnIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(40);
        }
        if ((foreignKeys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.FOREIGN_KEY)) == null) {
            return;
        }
        BasicModForeignKey foreignKey = (BasicModForeignKey)foreignKeys.createOrGet(StringUtil.notNullize((String)key2.name));
        foreignKey.setOnUpdate(GenericIntrospectorHelper.getCascadeRuleFromJdbcCode(key2.updateRule, this.myDbms.isPostgres()));
        foreignKey.setOnDelete(GenericIntrospectorHelper.getCascadeRuleFromJdbcCode(key2.deleteRule, this.myDbms.isPostgres()));
        DasForeignKey.Deferrability deferrability = JdbcUtil.getDeferrability((short)key2.deferrability);
        foreignKey.setDeferrable(deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
        foreignKey.setInitiallyDeferred(deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
        TreeMap columns = ContainerUtil.newTreeMap();
        for (DatabaseMetaDataWrapper.TableFKeyColumn column2 : JBIterable.once(columnIt)) {
            columns.put(column2.position, Pair.create((Object)column2.name, (Object)column2.targetName));
        }
        ArrayList sCols = ContainerUtil.newArrayList();
        ArrayList tCols = ContainerUtil.newArrayList();
        for (Pair column3 : columns.values()) {
            sCols.add(column3.first);
            tCols.add(column3.second);
        }
        String refSchemaName = StringUtil.nullize((String)(this.mySchemaDbMode ? key2.targetTable.schema.database : key2.targetTable.schema.schema));
        if (table.getSchema().getName().equals(refSchemaName)) {
            refSchemaName = null;
        }
        foreignKey.setRefSchemaName(refSchemaName);
        foreignKey.setRefTableName(key2.targetTable.name);
        foreignKey.setRefColNames(tCols);
        foreignKey.setColNames(sCols);
        foreignKey.setNameSurrogate(key2.surrogateName || this.isSurrogate(key2));
        DbImplUtil.resolveKey(foreignKey, tCols);
    }

    private static CascadeRule getCascadeRuleFromJdbcCode(short code, boolean isPostgres) {
        if (code == 0) {
            return CascadeRule.cascade;
        }
        if (code == 4) {
            return CascadeRule.set_default;
        }
        if (code == 2) {
            return CascadeRule.set_null;
        }
        if (code == 1) {
            return isPostgres ? CascadeRule.restrict : CascadeRule.no_action;
        }
        return CascadeRule.no_action;
    }

    public void createArguments(@Nullable BasicModRoutine procedure, @NotNull Iterator<DatabaseMetaDataWrapper.RoutineArgument> argumentIt) {
        BasicModArgument ra;
        if (argumentIt == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(41);
        }
        if (procedure == null) {
            return;
        }
        StringBuilder result2 = null;
        for (DatabaseMetaDataWrapper.RoutineArgument argument : JBIterable.once(argumentIt)) {
            if (argument.direction == DasArgument.Direction.RESULT) {
                if (result2 == null) {
                    result2 = new StringBuilder();
                }
                if (result2.length() != 0) {
                    result2.append(", ");
                }
                if (!StringUtil.isEmpty((String)argument.name)) {
                    result2.append(argument.name).append(" ");
                }
                result2.append(GenericIntrospectorHelper.makeDataType(argument).getSpecification());
                continue;
            }
            this.createArgument(procedure, argument);
        }
        if (result2 != null) {
            result2.insert(0, "table(").append(")");
            ra = procedure.createOrGetReturnArgument();
            ra.setArgumentDirection(DasArgument.Direction.RESULT);
            ra.setName(DasUtil.NO_NAME);
            ra.setDataType(DataTypeFactory.of(result2.toString()));
            ra.setDefaultExpression(null);
            ra.setPosition((short)0);
        }
        if (procedure.getRoutineKind() == DasRoutine.Kind.FUNCTION && ((ra = (BasicModArgument)procedure.getReturnArgument()) == null || ra.isSyncPending())) {
            ra = procedure.createOrGetReturnArgument();
            ra.setName(DasUtil.NO_NAME);
            ra.setDataType(DataType.UNKNOWN);
            ra.setDefaultExpression(null);
            ra.setPosition((short)0);
        }
    }

    public void createArgument(@NotNull BasicModRoutine procedure, @NotNull DatabaseMetaDataWrapper.RoutineArgument arg) {
        BasicModArgument argument;
        if (procedure == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(42);
        }
        if (arg == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(43);
        }
        if (arg.direction == DasArgument.Direction.RETURN) {
            argument = procedure.createOrGetReturnArgument();
            argument.setName(StringUtil.notNullize((String)arg.name, (String)ModelConsts.NO_NAME));
        } else {
            ModNamingFamily arguments = GenericIntrospectorLegacyModelUtils.familyOf(procedure, ObjectKind.ARGUMENT);
            if (arguments == null) {
                return;
            }
            argument = (BasicModArgument)arguments.createOrGet(StringUtil.notNullize((String)arg.name));
            argument.setArgumentDirection(arg.direction);
        }
        argument.setDataType(GenericIntrospectorHelper.makeDataType(arg));
        argument.setDefaultExpression(arg.def);
        argument.setPosition((short)arg.position);
        argument.setNotNull(!arg.nullable);
    }

    @NotNull
    private static DataType makeDataType(@NotNull DatabaseMetaDataWrapper.RoutineArgument arg) {
        if (arg == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(44);
        }
        DataType dataType = GenericIntrospectorHelper.makeDataType(StringUtil.notNullize((String)arg.typeName), arg.length, arg.scale, arg.typeSuffix, arg.type);
        if (dataType == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(45);
        }
        return dataType;
    }

    @NotNull
    public static DataType makeDataType(String name, int size, int scale, String suffix, int jdbcType) {
        DataType dataType = DataTypeFactory.of(null, name, size, scale, null, suffix, false, false, jdbcType);
        if (dataType == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(46);
        }
        return dataType;
    }

    public void setCasing(@Nullable Casing casing) {
        BasicRoot root2 = this.myModel.getRoot();
        if (casing != null && root2 instanceof BasicModRoot) {
            ((BasicModRoot)root2).setDefaultCasing(casing);
        }
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableIndex index2) {
        if (index2 == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(47);
        }
        return this.isSurrogate(StringUtil.notNullize((String)index2.name), ObjectKind.INDEX) || this.myDbms.isDb2() && "SYSIBM".equalsIgnoreCase(index2.qualifier);
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableKey key2) {
        if (key2 == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(48);
        }
        return this.isSurrogate(StringUtil.notNullize((String)key2.name), ObjectKind.KEY);
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableFKey key2) {
        if (key2 == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(49);
        }
        return this.isSurrogate(StringUtil.notNullize((String)key2.name), ObjectKind.FOREIGN_KEY);
    }

    private boolean isSurrogate(@NotNull String safeName, @NotNull ObjectKind kind) {
        if (safeName == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(50);
        }
        if (kind == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(51);
        }
        if (this.myDbms.isSqlite() && safeName.startsWith("sqlite_autoindex_")) {
            return true;
        }
        if (this.myDbms.isHsqldb()) {
            return kind == ObjectKind.INDEX && safeName.startsWith("SYS_IDX") || kind == ObjectKind.KEY && safeName.startsWith("SYS_PK") || kind == ObjectKind.FOREIGN_KEY && safeName.startsWith("SYS_FK");
        }
        if (this.myDbms.isH2()) {
            return kind == ObjectKind.INDEX && (safeName.startsWith("PRIMARY_KEY_") || safeName.startsWith("CONSTRAINT_INDEX_") || safeName.matches(".*_INDEX_\\w{1,3}")) || (kind == ObjectKind.KEY || kind == ObjectKind.FOREIGN_KEY) && safeName.startsWith("CONSTRAINT_");
        }
        if (this.myDbms.isDerby() && safeName.matches("SQL\\d{15}")) {
            return true;
        }
        if (this.myDbms.isDb2() && safeName.matches("SQL\\d{15}")) {
            return true;
        }
        if (this.myDbms.isSybase() && safeName.matches("^.*_\\d{5,}$")) {
            return true;
        }
        if (this.myDbms.isOracle() && safeName.startsWith("SYS_")) {
            return true;
        }
        if (this.myDbms.isMicrosoft()) {
            return kind == ObjectKind.INDEX && safeName.startsWith("PK__") || kind == ObjectKind.KEY && safeName.startsWith("PK__") || kind == ObjectKind.FOREIGN_KEY && safeName.startsWith("FK__");
        }
        return this.myDbms.isMysql() && safeName.equals("PRIMARY") && (kind == ObjectKind.INDEX || kind == ObjectKind.KEY);
    }

    @Nullable
    private String getRealPackage(@NotNull DatabaseMetaDataWrapper.Routine routine) {
        if (routine == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(52);
        }
        if (routine.pkg == null && this.myDbms.isSybase() && routine.kind == DasRoutine.Kind.PROCEDURE) {
            return routine.name;
        }
        return routine.pkg;
    }

    @Nullable
    private static BasicModElement getOrCreatePackage(@NotNull BasicModSchema schema, @NotNull String cat) {
        ModNamingFamily packages;
        if (schema == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(53);
        }
        if (cat == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(54);
        }
        return (packages = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.PACKAGE)) == null ? null : (BasicModElement)packages.createOrGet(cat);
    }

    @NotNull
    public String getProcName(@NotNull DatabaseMetaDataWrapper.Routine routine) {
        if (routine == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(55);
        }
        String string = MetaDataUtil.getProcName(routine.specificName, this.getRealPackage(routine));
        if (string == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    public String getSpecName(@NotNull BasicModRoutine routine) {
        if (routine == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(57);
        }
        String string = (String)ContainerUtil.getOrElse(this.myProcSpecNames, (Object)routine, (Object)routine.getName());
        if (string == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    private <T extends BasicModNamedElement> T getOrCreateRoutineBySpecName(@NotNull ModNamingFamily<T> f, @NotNull String name, @NotNull String specName) {
        BasicModNamedElement res2;
        if (f == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(59);
        }
        if (name == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(60);
        }
        if (specName == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(61);
        }
        if ((res2 = f.find(x -> {
            if (name == null) {
                GenericIntrospectorHelper.$$$reportNull$$$0(66);
            }
            if (specName == null) {
                GenericIntrospectorHelper.$$$reportNull$$$0(67);
            }
            return x != null && name.equals(x.getName()) && specName.equals(this.getSpecName((BasicModElement)x));
        })) == null && (res2 = f.find(x -> {
            if (name == null) {
                GenericIntrospectorHelper.$$$reportNull$$$0(65);
            }
            return x != null && name.equals(x.getName()) && !this.myProcSpecNames.containsKey(x);
        })) != null) {
            this.myProcSpecNames.put(res2, specName);
        }
        if (res2 != null) {
            res2.resetSyncPending();
        } else {
            res2 = (BasicModNamedElement)f.createNewOne();
            res2.setName(name);
            if (res2 instanceof BasicModSpecificRoutine) {
                ((BasicModSpecificRoutine)((Object)res2)).setSpecificName(specName);
            }
            this.myProcSpecNames.put(res2, specName);
        }
        BasicModNamedElement basicModNamedElement = res2;
        if (basicModNamedElement == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(62);
        }
        return (T)basicModNamedElement;
    }

    private String getSpecName(BasicModElement x) {
        String name = this.myProcSpecNames.get(x);
        if (x instanceof BasicModSpecificRoutine) {
            String specName = ((BasicModSpecificRoutine)x).getSpecificName();
            if (!Comparing.equal((String)specName, (String)name)) {
                this.myProcSpecNames.put(x, specName);
            }
            return specName;
        }
        return name;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(63);
        }
        return dbms;
    }

    @NotNull
    public RoutineMap createRoutineMap() {
        RoutineMap routineMap = new RoutineMap();
        if (routineMap == null) {
            GenericIntrospectorHelper.$$$reportNull$$$0(64);
        }
        return routineMap;
    }

    public boolean isSchemaDbMode() {
        return this.mySchemaDbMode;
    }

    private static <T> T needed(T t) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) assert (t != null) : "Missing needed family";
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 45: 
            case 46: 
            case 56: 
            case 58: 
            case 62: 
            case 63: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 45: 
            case 46: 
            case 56: 
            case 58: 
            case 62: 
            case 63: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 45: 
            case 46: 
            case 56: 
            case 58: 
            case 62: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/GenericIntrospectorHelper";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 17: 
            case 20: 
            case 25: 
            case 30: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyIt";
                break;
            }
            case 13: 
            case 39: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyColumnIt";
                break;
            }
            case 16: 
            case 52: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDefinedType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrIt";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 27: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIt";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexColumnIt";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkColumnIt";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentIt";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 60: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/GenericIntrospectorHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asSchema";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asTable";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDataType";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcName";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecName";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRoutineBySpecName";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createRoutineMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 45: 
            case 46: 
            case 56: 
            case 58: 
            case 62: 
            case 63: 
            case 64: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDatabase";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "asSchema";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asTable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createKeys";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRoutine";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createUserDefinedType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createUserDefinedTypeAttributes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createUserDefinedTypeAttribute";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "noNeedToShow";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createColumns";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createColumn";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createSchema";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createIndices";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createForeignKeys";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createForeignKey";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createArguments";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createArgument";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "makeDataType";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isSurrogate";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getRealPackage";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePackage";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getProcName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSpecName";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRoutineBySpecName";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateRoutineBySpecName$4";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateRoutineBySpecName$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 45: 
            case 46: 
            case 56: 
            case 58: 
            case 62: 
            case 63: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class RoutineMap {
        private final Map<String, BasicModRoutine> name2Routine = ContainerUtil.newHashMap();

        @Nullable
        public DasRoutine.Kind guessType(DatabaseMetaDataWrapper.Routine r) {
            BasicModRoutine routine = this.name2Routine.get(MetaDataUtil.getProcName(r.specificName, r.pkg));
            if (routine == null && GenericIntrospectorHelper.this.getDbms().isSybase()) {
                routine = this.name2Routine.get(MetaDataUtil.getProcName(r.specificName, r.name));
            }
            return routine == null ? DasRoutine.Kind.NONE : routine.getRoutineKind();
        }

        @Nullable
        public BasicModRoutine get(DatabaseMetaDataWrapper.Routine r) {
            return this.name2Routine.get(GenericIntrospectorHelper.this.getProcName(r));
        }

        public void put(@NotNull BasicModRoutine routine) {
            if (routine == null) {
                RoutineMap.$$$reportNull$$$0(0);
            }
            this.name2Routine.put(MetaDataUtil.getProcName(GenericIntrospectorHelper.this.getSpecName(routine), this.getPackage(routine)), routine);
        }

        @Nullable
        private String getPackage(BasicModRoutine routine) {
            BasicElement parent2 = routine.getParent();
            return parent2 == null || parent2.getKind() != ObjectKind.PACKAGE ? null : parent2.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/generic/introspector/GenericIntrospectorHelper$RoutineMap", "put"));
        }
    }
}

