/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.stubs.SqlAllNameIndex;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlTableKeyElementType<T extends SqlKIFKImpl<?>>
extends SqlStubElementType<SqlTableKeyStub<T>, T> {
    public static final NotNullFunction<String, SqlTableKeyElementType> FACTORY = name -> new SqlTableKeyElementType((String)name);

    public static <T extends SqlKIFKImpl<?>> NotNullFunction<String, SqlTableKeyElementType<T>> factory() {
        return FACTORY;
    }

    protected SqlTableKeyElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @NotNull
    public SqlTableKeyStub<T> createStub(@NotNull T psi, StubElement parentStub) {
        if (psi == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(1);
        }
        String tableName = ((SqlKIFKImpl)((Object)psi)).getTableName();
        Iterable columnNames = ((SqlKIFKImpl)((Object)psi)).getColumnsRef().names();
        String keyText = tableName == null ? null : SqlTableKeyElementType.tableColumnList(tableName, columnNames);
        SqlNameElement nameElement = ((SqlStubbedDefinitionImpl)((Object)psi)).getNameElement();
        boolean unique = false;
        if (psi instanceof SqlIndexDefinition) {
            unique = ((SqlIndexDefinition)psi).isUnique();
        }
        SqlTableKeyStub sqlTableKeyStub = new SqlTableKeyStub(parentStub, this, SqlTableKeyElementType.asStringRef((PsiElement)nameElement), keyText == null ? null : StringRef.fromString((String)keyText), unique);
        if (sqlTableKeyStub == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(2);
        }
        return sqlTableKeyStub;
    }

    @Override
    public void indexStub(@NotNull SqlTableKeyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(3);
        }
        if (sink == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(4);
        }
        SqlTableKeyElementType.indexNamedStub(stub, SqlAllNameIndex.KEY, sink);
    }

    public void serialize(@NotNull SqlTableKeyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(5);
        }
        if (dataStream == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(6);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getKeyText());
        dataStream.writeBoolean(stub.isUnique());
    }

    @NotNull
    public SqlTableKeyStub<T> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(7);
        }
        SqlTableKeyStub sqlTableKeyStub = new SqlTableKeyStub(parentStub, this, dataStream.readName(), dataStream.readName(), dataStream.readBoolean());
        if (sqlTableKeyStub == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(8);
        }
        return sqlTableKeyStub;
    }

    static String tableColumnList(String tableName, Iterable<String> columnNames) {
        if (Iterables.isEmpty(columnNames)) {
            return tableName;
        }
        return tableName + "(" + StringUtil.join(columnNames, (String)",") + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlTableKeyElementType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlTableKeyElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

