/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class HidpiInfo
extends AnAction
implements DumbAware {
    private static final boolean ENABLED = UIUtil.isJreHiDPIEnabled();
    private static final String JRE_HIDPI_MODE_TEXT = "Per-monitor DPI-aware";
    private static final String JRE_HIDPI_MODE_DESC = "<html><span style='font-size:x-small'>When enabled, the IDE UI scaling honors per-monitor DPI.<br>" + (SystemInfo.isWindows ? "To " + (ENABLED ? "disable" : "enable") + " set the JVM option <code>-Dsun.java2d.uiScale.enabled=" + (ENABLED ? "false" : "true") + "</code> and restart.</span></html>" : "The mode can not be changed on this platform.");
    private static final String SYS_SCALE_TEXT = "Monitor scale";
    private static final String SYS_SCALE_DESC = "<html><span style='font-size:x-small'>" + (ENABLED ? "The current monitor scale factor" : "The main monitor scale factor") + ".</span></html>";
    private static final String USR_SCALE_TEXT = "User (IDE) scale";
    private static final String USR_SCALE_DESC = "<html><span style='font-size:x-small'>The global IDE scale factor" + (JBUI.DEBUG_USER_SCALE_FACTOR.isNotNull() ? ", overridden by the debug property." : ", derived from the main font size: <code>$LABEL_FONT_SIZE" + (ENABLED ? "pt" : "px") + "</code><br><code>" + (SystemInfo.isMac ? "Preferences " : "Settings ") + "> Appearance & Behaviour > Appearance > Override default font") + "</code></span></html>";

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Window activeFrame;
        if (anActionEvent == null) {
            HidpiInfo.$$$reportNull$$$0(0);
        }
        if ((activeFrame = IdeFrameImpl.getActiveFrame()) == null) {
            return;
        }
        String _USR_SCALE_DESC = USR_SCALE_DESC.replace("$LABEL_FONT_SIZE", "" + UIUtil.getLabelFont().getSize());
        Object[] columns = new String[]{"Property", "Value", "Description"};
        Object[][] data = new String[][]{{JRE_HIDPI_MODE_TEXT, ENABLED ? "enabled" : "disabled", JRE_HIDPI_MODE_DESC}, {SYS_SCALE_TEXT, "" + JBUI.sysScale((Component)activeFrame), SYS_SCALE_DESC}, {USR_SCALE_TEXT, "" + JBUI.scale((float)1.0f), _USR_SCALE_DESC}};
        JTable table = new JTable(data, columns, (String[][])data){
            final /* synthetic */ String[][] val$data;
            {
                this.val$data = stringArray;
                super(x0, x1);
            }

            @Override
            public TableCellRenderer getCellRenderer(int row2, int column) {
                return (table1, value, isSelected, hasFocus, row1, column1) -> HidpiInfo.label(this.val$data[row1][column1]);
            }

            @Override
            public boolean isCellEditable(int row2, int column) {
                return false;
            }
        };
        BiFunction<Integer, Integer, Dimension> size = (arg_0, arg_1) -> HidpiInfo.lambda$actionPerformed$0((String[][])data, arg_0, arg_1);
        int maxDescColumnWidth = Math.max(size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)2)).width, Math.max(size.apply((Integer)Integer.valueOf((int)1), (Integer)Integer.valueOf((int)2)).width, size.apply((Integer)Integer.valueOf((int)2), (Integer)Integer.valueOf((int)2)).width));
        table.setColumnSelectionAllowed(true);
        TableColumnModel tcm = table.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)0)).width + JBUI.scale((int)10));
        tcm.getColumn(1).setPreferredWidth(size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)1)).width + JBUI.scale((int)10));
        tcm.getColumn(2).setPreferredWidth(maxDescColumnWidth + JBUI.scale((int)10));
        table.setRowHeight(0, size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)2)).height);
        table.setRowHeight(1, size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)2)).height);
        table.setRowHeight(2, size.apply((Integer)Integer.valueOf((int)2), (Integer)Integer.valueOf((int)2)).height);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)table, "Center");
        tablePanel.add((Component)table.getTableHeader(), "North");
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)tablePanel, null).setTitle("HiDPI Info").createPopup().showInCenterOf((Component)activeFrame);
    }

    private static JLabel label(String text) {
        JLabel label2 = new JLabel(text);
        label2.setBorder(JBUI.Borders.empty((int)2));
        return label2;
    }

    private static /* synthetic */ Dimension lambda$actionPerformed$0(String[][] data, Integer row2, Integer col) {
        return HidpiInfo.label(data[row2][col]).getPreferredSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/intellij/internal/HidpiInfo", "actionPerformed"));
    }
}

