/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import icons.RubyIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettingsPanel;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettingsPanelImpl;

public class CompassSettingsPanelForRubyModule
implements CompassSettingsPanel {
    @NotNull
    private final Module myModule;
    @NotNull
    private JCheckBox myCompassEnabledCheckBox;
    private TextFieldWithHistoryWithBrowseButton myCompassConfigPathTextField;
    private JPanel myPanel;
    private JLabel myCompassGemLabel;
    private JBLabel myConfigPathLabel;
    private JBLabel myCompassGemTitleLabel;

    public CompassSettingsPanelForRubyModule(@NotNull Module module, @NotNull List<String> configFilesVariants, boolean fullMode) {
        if (module == null) {
            CompassSettingsPanelForRubyModule.$$$reportNull$$$0(0);
        }
        if (configFilesVariants == null) {
            CompassSettingsPanelForRubyModule.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myCompassConfigPathTextField.setPreferredSize(new Dimension(fullMode ? 100 : 400, -1));
        this.myModule = module;
        this.myCompassEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompassSettingsPanelForRubyModule.this.updateUiComponents();
            }
        });
        Project project = module.getProject();
        CompassSettingsPanelImpl.initCompassConfigPathTextField((Project)project, configFilesVariants, (TextFieldWithHistoryWithBrowseButton)this.myCompassConfigPathTextField);
    }

    public boolean isModified(@Nullable CompassSettings compassSettings) {
        return this.isEnableOptionChanged(compassSettings) || this.isConfigFilePathChanged(compassSettings);
    }

    public boolean isConfigFilePathChanged(@Nullable CompassSettings compassSettings) {
        return compassSettings != null && !compassSettings.getCompassConfigPath().equals(this.getCompassConfigPath());
    }

    public boolean isExecutablePathChanged(@Nullable CompassSettings compassSettings) {
        return false;
    }

    public boolean isEnableOptionChanged(@Nullable CompassSettings compassSettings) {
        return compassSettings != null && compassSettings.isCompassSupportEnabled() != this.isCompassSupportEnabled();
    }

    public void apply(@Nullable CompassSettings compassSettings) {
        if (compassSettings != null) {
            compassSettings.setCompassSupportEnabled(this.isCompassSupportEnabled());
            compassSettings.setCompassConfigPath(this.getCompassConfigPath());
        }
    }

    public void reset(@Nullable CompassSettings compassSettings) {
        if (compassSettings != null) {
            boolean compassSupportEnabled = compassSettings.isCompassSupportEnabled();
            this.myCompassEnabledCheckBox.setSelected(compassSupportEnabled);
            ((TextFieldWithHistory)this.myCompassConfigPathTextField.getChildComponent()).setText(compassSettings.getCompassConfigPath());
        }
        if (compassSettings == null) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)false, (boolean)true);
        }
        this.updateUiComponents();
    }

    public boolean isCompassSupportEnabled() {
        return this.myCompassEnabledCheckBox.isSelected();
    }

    @NotNull
    public String getCompassConfigPath() {
        String string = StringUtil.notNullize((String)((TextFieldWithHistory)this.myCompassConfigPathTextField.getChildComponent()).getText());
        if (string == null) {
            CompassSettingsPanelForRubyModule.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CompassSettingsPanelForRubyModule.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void dispose() {
    }

    private void updateUiComponents() {
        this.myCompassGemTitleLabel.setEnabled(this.myCompassEnabledCheckBox.isSelected());
        this.myConfigPathLabel.setEnabled(this.myCompassEnabledCheckBox.isSelected());
        UIUtil.setEnabled((Component)this.myCompassConfigPathTextField, (boolean)this.myCompassEnabledCheckBox.isSelected(), (boolean)true);
        GemInfo compassGem = GemSearchUtil.findGemEx((Module)this.myModule, (String)SASSBundle.message((String)"compass.gem.name"));
        if (compassGem != null) {
            this.myCompassGemLabel.setIcon(RubyIcons.Ruby.Ruby);
            this.myCompassGemLabel.setText(compassGem.getLibraryName());
        } else {
            this.myCompassGemLabel.setIcon(AllIcons.Actions.Lightning);
            this.myCompassGemLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'><left>Cannot find compass gem in module</left></b></font>")));
        }
        this.myCompassGemLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.myCompassGemLabel.revalidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilesVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/CompassSettingsPanelForRubyModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/CompassSettingsPanelForRubyModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompassConfigPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JBLabel jBLabel;
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConfigPathLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/sass/SASSBundle").getString("compass.support.config.path"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myCompassConfigPathTextField = textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        jPanel2.add((Component)textFieldWithHistoryWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCompassGemTitleLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("org/jetbrains/plugins/sass/SASSBundle").getString("compass.support.compass.gem"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myCompassGemLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompassEnabledCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/plugins/sass/SASSBundle").getString("compass.support.enabled.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

