/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.rewriter;

import java.util.Iterator;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.rewriter.ReWriteVisitor;
import org.jrubyparser.rewriter.utils.ReWriterContext;

public class ClassBodyWriter {
    private ReWriteVisitor visitor;
    private Node bodyNode;
    private ReWriterContext context;

    public ClassBodyWriter(ReWriteVisitor visitor, Node bodyNode) {
        this.visitor = visitor;
        this.bodyNode = bodyNode;
        this.context = visitor.getConfig();
    }

    public void write() {
        if (this.bodyNode instanceof BlockNode) {
            this.context.getIndentor().indent();
            this.writeContent((BlockNode)this.bodyNode);
            this.context.getIndentor().outdent();
        } else if (this.bodyNode instanceof NewlineNode) {
            this.visitor.visitNodeInIndentation(this.bodyNode);
        } else {
            this.visitor.visitNode(this.bodyNode);
        }
    }

    private void writeContent(BlockNode node) {
        Iterator<Node> it = node.childNodes().iterator();
        while (it.hasNext()) {
            this.visitor.visitNode(it.next());
            if (!it.hasNext()) continue;
            this.context.getOutput().print(this.context.getFormatHelper().classBodyElementsSeparator());
        }
    }
}

