/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.ruby;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberCallIndex;
import org.jetbrains.plugins.ruby.cucumber.ruby.steps.RubyStepDefinition;
import org.jetbrains.plugins.ruby.cucumber.ruby.steps.RubyStepDefinitionCreator;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubyCucumberExtension
extends AbstractCucumberExtension {
    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            RubyCucumberExtension.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            RubyCucumberExtension.$$$reportNull$$$0(1);
        }
        return parent instanceof PsiDirectory && child instanceof RFile;
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        Module[] modules;
        if (child == null) {
            RubyCucumberExtension.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            RubyCucumberExtension.$$$reportNull$$$0(3);
        }
        if (!this.isStepLikeFile(child, parent)) {
            return false;
        }
        for (Module module : modules = ModuleManager.getInstance((Project)child.getProject()).getModules()) {
            if (!module.getModuleScope(true).uniteWith(module.getModuleContentScope()).accept(child.getContainingFile().getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        BDDFrameworkType bDDFrameworkType = new BDDFrameworkType((FileType)RubyFileType.RUBY);
        if (bDDFrameworkType == null) {
            RubyCucumberExtension.$$$reportNull$$$0(4);
        }
        return bDDFrameworkType;
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        RubyStepDefinitionCreator rubyStepDefinitionCreator = new RubyStepDefinitionCreator();
        if (rubyStepDefinitionCreator == null) {
            RubyCucumberExtension.$$$reportNull$$$0(5);
        }
        return rubyStepDefinitionCreator;
    }

    @Nullable
    protected String getStepVariant(@NotNull PsiElement element) {
        if (element == null) {
            RubyCucumberExtension.$$$reportNull$$$0(6);
        }
        if (element instanceof RListOfExpressions) {
            RCall stepCall = CucumberUtil.getStepInvocation(element);
            if (stepCall == null) {
                return null;
            }
            PsiElement parameter = (PsiElement)stepCall.getArguments().get(0);
            return CucumberUtil.getStepNameFromStepCall(parameter);
        }
        return super.getStepVariant(element);
    }

    @NotNull
    public Collection<String> getGlues(@NotNull GherkinFile file, Set<String> gluesFromOtherFiles) {
        if (file == null) {
            RubyCucumberExtension.$$$reportNull$$$0(7);
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            RubyCucumberExtension.$$$reportNull$$$0(8);
        }
        return set;
    }

    public static List<AbstractStepDefinition> getAllStepDefinitions(@NotNull Module module) {
        if (module == null) {
            RubyCucumberExtension.$$$reportNull$$$0(9);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true).uniteWith(module.getModuleContentWithDependenciesScope());
        ArrayList<RCall> cucumberCalls = new ArrayList<RCall>(RubyCucumberCallIndex.findAll(module.getProject(), scope));
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (RCall call : cucumberCalls) {
            if (!CucumberUtil.enabledStepDefinition((PsiElement)call)) continue;
            result.add(new RubyStepDefinition((PsiElement)call));
        }
        return result;
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            RubyCucumberExtension.$$$reportNull$$$0(10);
        }
        return RubyCucumberExtension.getAllStepDefinitions(module);
    }

    public Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile file) {
        Module module;
        if (file == null) {
            RubyCucumberExtension.$$$reportNull$$$0(11);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return Collections.emptySet();
        }
        List<AbstractStepDefinition> stepDefs = this.loadStepsFor((PsiFile)file, module);
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        for (AbstractStepDefinition stepDef : stepDefs) {
            PsiFile psiFile;
            PsiElement stepDefElement = stepDef.getElement();
            if (stepDefElement == null || !this.isWritableStepLikeFile((PsiElement)(psiFile = stepDefElement.getContainingFile()), (PsiElement)psiFile.getParent())) continue;
            result.add(psiFile);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/ruby/RubyCucumberExtension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/ruby/RubyCucumberExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionCreator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isStepLikeFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isWritableStepLikeFile";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStepVariant";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGlues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllStepDefinitions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

