/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.Frame;

public class PaintbrushTool {
    int radius = 5;
    private final ClipPanel clipPanel;
    private final Clip clip;
    private final PaintbrushMouseHandler mouseHandler = new PaintbrushMouseHandler();

    public PaintbrushTool(ClipPanel clipPanel) {
        this.clipPanel = clipPanel;
        this.clip = clipPanel.getClip();
        clipPanel.addMouseListener(this.mouseHandler);
        clipPanel.addMouseMotionListener(this.mouseHandler);
    }

    public void discard() {
        this.clipPanel.removeMouseListener(this.mouseHandler);
        this.clipPanel.removeMouseMotionListener(this.mouseHandler);
    }

    public int getRadius() {
        return this.radius;
    }

    private class PaintbrushMouseHandler
    implements MouseMotionListener,
    MouseListener {
        private PaintbrushMouseHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            Point p = PaintbrushTool.this.clipPanel.toClipCoords(e.getPoint());
            for (int x = p.x - PaintbrushTool.this.radius; x < p.x + PaintbrushTool.this.radius; ++x) {
                Frame f = PaintbrushTool.this.clip.getFrame(x);
                for (int y = p.y - PaintbrushTool.this.radius; y < p.y + PaintbrushTool.this.radius; ++y) {
                    f.setReal(y, 0.0);
                }
            }
            Rectangle updateRegion = new Rectangle(e.getX() - PaintbrushTool.this.radius, e.getY() - PaintbrushTool.this.radius, PaintbrushTool.this.radius * 2, PaintbrushTool.this.radius * 2);
            PaintbrushTool.this.clipPanel.updateImage(updateRegion);
            PaintbrushTool.this.clipPanel.repaint(e.getX() - PaintbrushTool.this.radius, e.getY() - PaintbrushTool.this.radius, PaintbrushTool.this.radius * 2, PaintbrushTool.this.radius * 2);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.mouseDragged(e);
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

