/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.tool;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipDataEdit;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.Frame;
import net.bluecow.spectro.SpectroEditSession;
import net.bluecow.spectro.tool.Tool;

public class RegionScaleTool
implements Tool {
    private ClipPanel clipPanel;
    private Clip clip;
    private final PropertyChangeListener clipEventHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("region".equals(evt.getPropertyName())) {
                RegionScaleTool.this.scaleSlider.setValue(100);
            }
        }
    };
    private ClipDataEdit origData;
    private final Box settingsPanel = Box.createVerticalBox();
    private final JSlider scaleSlider;
    private final int initialScale = 100;

    public RegionScaleTool() {
        this.settingsPanel.add(new JLabel("Scale amount"));
        this.scaleSlider = new JSlider(0, 500, 100);
        this.scaleSlider.setOpaque(false);
        this.scaleSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (RegionScaleTool.this.scaleSlider.getValueIsAdjusting()) {
                    RegionScaleTool.this.scaleRegion((double)RegionScaleTool.this.scaleSlider.getValue() / 100.0);
                }
            }
        });
        this.settingsPanel.add(this.scaleSlider);
        this.settingsPanel.add(Box.createGlue());
    }

    public String getName() {
        return "Scale Region";
    }

    public void activate(SpectroEditSession session) {
        this.clipPanel = session.getClipPanel();
        this.clip = this.clipPanel.getClip();
        this.clipPanel.setRegionMode(true);
        this.clipPanel.addPropertyChangeListener("region", this.clipEventHandler);
    }

    public void deactivate() {
        if (this.origData != null) {
            this.origData = null;
        }
        this.clipPanel.removePropertyChangeListener("region", this.clipEventHandler);
        this.clip = null;
        this.clipPanel = null;
    }

    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }

    public String toString() {
        return "Region";
    }

    public void scaleRegion(double amount) {
        Rectangle region = this.clipPanel.getRegion();
        if (region == null || region.width == 0 || region.height == 0) {
            this.origData = null;
            return;
        }
        Rectangle frameRegion = this.clipPanel.toClipCoords(new Rectangle(region));
        if (this.origData == null || !this.origData.isSameRegion(frameRegion)) {
            this.origData = new ClipDataEdit(this.clip, frameRegion);
        }
        this.clip.beginEdit(frameRegion, "Scale Region");
        double[][] orig = this.origData.getOldData();
        for (int i = frameRegion.x; i < frameRegion.x + frameRegion.width; ++i) {
            Frame frame = this.clip.getFrame(i);
            for (int j = frameRegion.y; j < frameRegion.y + frameRegion.height; ++j) {
                frame.setReal(j, orig[i - frameRegion.x][j - frameRegion.y] * amount);
            }
        }
        this.clip.endEdit();
    }
}

