/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private int tabCount = 0;
    private boolean checkIsShowing = false;

    public ThreadCheckingRepaintManager() {
    }

    public ThreadCheckingRepaintManager(boolean checkIsShowing) {
        this.checkIsShowing = checkIsShowing;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThread(jComponent);
        super.addInvalidComponent(jComponent);
    }

    private void checkThread(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && this.checkIsShowing(c)) {
            System.out.println("----------Wrong Thread START");
            System.out.println(this.getStracktraceAsString(new Exception()));
            this.dumpComponentTree(c);
            System.out.println("----------Wrong Thread END");
        }
    }

    private String getStracktraceAsString(Exception e) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        e.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }

    private boolean checkIsShowing(JComponent c) {
        if (!this.checkIsShowing) {
            return true;
        }
        return c.isShowing();
    }

    @Override
    public synchronized void addDirtyRegion(JComponent jComponent, int i, int i1, int i2, int i3) {
        this.checkThread(jComponent);
        super.addDirtyRegion(jComponent, i, i1, i2, i3);
    }

    private void dumpComponentTree(Component c) {
        System.out.println("----------Component Tree");
        this.resetTabCount();
        while (c != null) {
            this.printTabIndent();
            System.out.println(c);
            this.printTabIndent();
            System.out.println("Showing:" + c.isShowing() + " Visible: " + c.isVisible());
            this.incrementTabCount();
            c = c.getParent();
        }
    }

    private void resetTabCount() {
        this.tabCount = 0;
    }

    private void incrementTabCount() {
        ++this.tabCount;
    }

    private void printTabIndent() {
        for (int i = 0; i < this.tabCount; ++i) {
            System.out.print("\t");
        }
    }
}

