/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.XYPair;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

class XYChartCreator {
    private DataScale _xAxisDataScale;
    private DataScale _yAxisDataScale;
    private DataScaleTable _dataScaleTable;
    private String _title;
    private JFreeChart _chart;
    private String _label;

    public XYChartCreator(DataScale xAxisDataScale, DataScale yAxisDataScale, DataScaleTable dataScaleTable) {
        this._xAxisDataScale = xAxisDataScale;
        this._yAxisDataScale = yAxisDataScale;
        this._dataScaleTable = dataScaleTable;
        this._title = "Chart for x = " + this._xAxisDataScale.getColumnDisplayDefinition().getColumnName() + ", y = " + this._yAxisDataScale.getColumnDisplayDefinition().getColumnName();
        String category = this._xAxisDataScale.getColumnDisplayDefinition().getColumnName();
        DefaultXYDataset defaultXYDataset = new DefaultXYDataset();
        ArrayList<Double> xValues = this._dataScaleTable.getDoubleValuesForColumn(this._xAxisDataScale.getColumnDisplayDefinition());
        ArrayList<Double> yValues = this._dataScaleTable.getDoubleValuesForColumn(this._yAxisDataScale.getColumnDisplayDefinition());
        ArrayList<XYPair> pairs = XYPair.createSortedPairs(xValues, yValues);
        double[][] series = new double[2][pairs.size()];
        for (int i = 0; i < pairs.size(); ++i) {
            series[0][i] = pairs.get(i).getX();
            series[1][i] = pairs.get(i).getY();
        }
        defaultXYDataset.addSeries((Comparable)((Object)this._title), series);
        this._chart = ChartFactory.createXYLineChart((String)this._title, (String)category, (String)this._yAxisDataScale.getColumnDisplayDefinition().getColumnName(), (XYDataset)defaultXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this._label = "";
    }

    public String getTitle() {
        return this._title;
    }

    public JFreeChart getChart() {
        return this._chart;
    }

    public String getLabel() {
        return this._label;
    }
}

