/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.openoffice.xmerge.converter.xml.EmbeddedBinaryObject;
import org.openoffice.xmerge.converter.xml.OfficeDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.MIMETypes;
import writer2latex.office.SVMReader;
import writer2latex.util.Misc;
import writer2latex.xmerge.BinaryGraphicsDocument;

public final class ImageLoader {
    private OfficeDocument oooDoc;
    private String sOutFileName;
    private int nImageCount = 0;
    private boolean bExtractEPS;

    public ImageLoader(OfficeDocument oooDoc, String sOutFileName, boolean bExtractEPS) {
        this.oooDoc = oooDoc;
        this.sOutFileName = sOutFileName;
        this.bExtractEPS = bExtractEPS;
    }

    public BinaryGraphicsDocument getImage(Node node) {
        int[] offlen;
        String sMIME = null;
        String sExt = null;
        byte[] blob = null;
        String sHref = Misc.getAttribute(node, "xlink:href");
        if (sHref == null) {
            Element obd = Misc.getChildByTagName(node, "office:binary-data");
            if (obd != null) {
                StringBuffer buf = new StringBuffer();
                NodeList nl = obd.getChildNodes();
                int nLen = nl.getLength();
                int i = 0;
                while (i < nLen) {
                    if (nl.item(i).getNodeType() == 3) {
                        buf.append(nl.item(i).getNodeValue());
                    }
                    ++i;
                }
                blob = null;
            }
        } else if (sHref.startsWith("#")) {
            if ((sHref = sHref.substring(1)).startsWith("./")) {
                sHref = sHref.substring(2);
            }
            if (this.oooDoc.getEmbeddedObject(sHref) instanceof EmbeddedBinaryObject) {
                EmbeddedBinaryObject object = (EmbeddedBinaryObject)this.oooDoc.getEmbeddedObject(sHref);
                blob = object.getBinaryData();
                sMIME = object.getType();
                sExt = MIMETypes.getFileExtension(sMIME);
            }
        }
        if (blob == null) {
            return null;
        }
        String sName = this.sOutFileName + "-img" + ++this.nImageCount;
        BinaryGraphicsDocument bgd = null;
        if (this.bExtractEPS && "(starview metafile)".equals(MIMETypes.getMagicMIMEType(blob)) && SVMReader.readSVM(blob, offlen = new int[2])) {
            bgd = new BinaryGraphicsDocument(sName, ".eps", "image/x-eps");
            bgd.read(blob, offlen[0], offlen[1]);
        }
        if (bgd == null) {
            bgd = new BinaryGraphicsDocument(sName, sExt, sMIME);
            bgd.read(blob);
        }
        return bgd;
    }
}

