/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.util.ArrayList;
import org.apache.zookeeper.graph.FilterException;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.filterops.AndOp;
import org.apache.zookeeper.graph.filterops.Arg;
import org.apache.zookeeper.graph.filterops.EqualsOp;
import org.apache.zookeeper.graph.filterops.GreaterThanOp;
import org.apache.zookeeper.graph.filterops.LessThanOp;
import org.apache.zookeeper.graph.filterops.NotOp;
import org.apache.zookeeper.graph.filterops.OrOp;
import org.apache.zookeeper.graph.filterops.XorOp;

public abstract class FilterOp {
    protected ArrayList<FilterOp> subOps = new ArrayList();
    protected ArrayList<Arg> args = new ArrayList();

    public static FilterOp newOp(String op) throws FilterException {
        if (op.equals("or")) {
            return new OrOp();
        }
        if (op.equals("and")) {
            return new AndOp();
        }
        if (op.equals("not")) {
            return new NotOp();
        }
        if (op.equals("xor")) {
            return new XorOp();
        }
        if (op.equals("=")) {
            return new EqualsOp();
        }
        if (op.equals("<")) {
            return new LessThanOp();
        }
        if (op.equals(">")) {
            return new GreaterThanOp();
        }
        throw new FilterException("Invalid operation '" + op + "'");
    }

    public void addSubOp(FilterOp op) {
        this.subOps.add(op);
    }

    public void addArg(Arg arg) {
        this.args.add(arg);
    }

    public abstract boolean matches(LogEntry var1) throws FilterException;

    public String toString() {
        String op = "(" + this.getClass().getName();
        for (FilterOp f : this.subOps) {
            op = op + " " + f;
        }
        for (Arg a : this.args) {
            op = op + " " + a;
        }
        return op + ")";
    }

    public static enum ArgType {
        STRING,
        NUMBER,
        SYMBOL;

    }
}

