/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.List;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.IEditorSettings;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.autocompleter.IAutoCompleter;
import org.omegat.gui.editor.mark.Mark;

public interface IEditor {
    public String getCurrentFile();

    public String getCurrentTargetFile();

    public SourceTextEntry getCurrentEntry();

    public int getCurrentEntryNumber();

    public void activateEntry();

    public void commitAndDeactivate();

    public void commitAndLeave();

    public void nextEntry();

    public void prevEntry();

    public void nextXAutoEntry();

    public void prevXAutoEntry();

    public void nextXEnforcedEntry();

    public void prevXEnforcedEntry();

    public void nextEntryWithNote();

    public void prevEntryWithNote();

    public void nextUntranslatedEntry();

    public void nextTranslatedEntry();

    public void nextUniqueEntry();

    public void gotoFile(int var1) throws IndexOutOfBoundsException;

    public void gotoEntry(int var1);

    public void gotoEntry(int var1, CaretPosition var2);

    public void gotoEntry(String var1, EntryKey var2);

    public void gotoEntryAfterFix(int var1, String var2);

    public void refreshViewAfterFix(List<Integer> var1);

    public void refreshView(boolean var1);

    public void requestFocus();

    public void changeCase(CHANGE_CASE_TO var1);

    public void replaceEditText(String var1, String var2);

    public void replaceEditText(String var1);

    public void replaceEditTextAndMark(String var1, String var2);

    public void replaceEditTextAndMark(String var1);

    public void insertText(String var1);

    public void insertTextAndMark(String var1);

    public void insertTag(String var1);

    public void gotoHistoryForward();

    public void gotoHistoryBack();

    public IEditorSettings getSettings();

    public void undo();

    public void redo();

    public String getSelectedText();

    public void selectSourceText();

    public void setAlternateTranslationForCurrentEntry(boolean var1);

    public void markActiveEntrySource(SourceTextEntry var1, List<Mark> var2, String var3);

    public void registerPopupMenuConstructors(int var1, IPopupMenuConstructor var2);

    public void remarkOneMarker(String var1);

    public IEditorFilter getFilter();

    public void setFilter(IEditorFilter var1);

    public void removeFilter();

    public String getCurrentTranslation();

    public void windowDeactivated();

    public void registerUntranslated();

    public void registerEmptyTranslation();

    public void registerIdenticalTranslation();

    public IAutoCompleter getAutoCompleter();

    public static class CaretPosition {
        Integer position;
        Integer selectionStart;
        Integer selectionEnd;

        public CaretPosition(int position) {
            this.position = position;
            this.selectionStart = null;
            this.selectionEnd = null;
        }

        public CaretPosition(int selectionStart, int selectionEnd) {
            this.position = null;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }

        public static CaretPosition startOfEntry() {
            return new CaretPosition(0);
        }
    }

    public static enum CHANGE_CASE_TO {
        LOWER,
        SENTENCE,
        TITLE,
        UPPER,
        CYCLE;

    }
}

