/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import java.util.Locale;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Tag;

public class HasAttributeFilter
implements NodeFilter {
    protected String mAttribute;
    protected String mValue;

    public HasAttributeFilter() {
        this("", null);
    }

    public HasAttributeFilter(String attribute) {
        this(attribute, null);
    }

    public HasAttributeFilter(String attribute, String value) {
        this.mAttribute = attribute.toUpperCase(Locale.ENGLISH);
        this.mValue = value;
    }

    public String getAttributeName() {
        return this.mAttribute;
    }

    public void setAttributeName(String name) {
        this.mAttribute = name;
    }

    public String getAttributeValue() {
        return this.mValue;
    }

    public void setAttributeValue(String value) {
        this.mValue = value;
    }

    @Override
    public boolean accept(Node node) {
        boolean ret = false;
        if (node instanceof Tag) {
            Tag tag = (Tag)node;
            Attribute attribute = tag.getAttributeEx(this.mAttribute);
            boolean bl = ret = null != attribute;
            if (ret && null != this.mValue) {
                ret = this.mValue.equals(attribute.getValue());
            }
        }
        return ret;
    }
}

