/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.TermSpans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanTermQuery
extends SpanQuery {
    protected Term term;

    public SpanTermQuery(Term term) {
        this.term = Objects.requireNonNull(term);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String getField() {
        return this.term.field();
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        terms.add(this.term);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (this.term.field().equals(field)) {
            buffer.append(this.term.text());
        } else {
            buffer.append(this.term.toString());
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.term.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SpanTermQuery other = (SpanTermQuery)obj;
        return this.term.equals(other.term);
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        TermState state;
        TermContext termContext = termContexts.get(this.term);
        if (termContext == null) {
            Terms terms = context.reader().terms(this.term.field());
            if (terms != null) {
                if (!terms.hasPositions()) {
                    throw new IllegalStateException("field \"" + this.term.field() + "\" was indexed without position data; cannot run SpanTermQuery (term=" + this.term.text() + ")");
                }
                TermsEnum termsEnum = terms.iterator();
                state = termsEnum.seekExact(this.term.bytes()) ? termsEnum.termState() : null;
            } else {
                state = null;
            }
        } else {
            state = termContext.get(context.ord);
        }
        if (state == null) {
            return null;
        }
        TermsEnum termsEnum = context.reader().terms(this.term.field()).iterator();
        termsEnum.seekExact(this.term.bytes(), state);
        PostingsEnum postings = termsEnum.postings(acceptDocs, null, 88);
        return new TermSpans(postings, this.term);
    }
}

