/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.util.Collection;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.BigTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.utils.ChecksumType;

public class BigFormat
implements SSTableFormat {
    public static final BigFormat instance = new BigFormat();
    public static final Version latestVersion = new BigVersion("mc");
    private static final SSTableReader.Factory readerFactory = new ReaderFactory();
    private static final SSTableWriter.Factory writerFactory = new WriterFactory();

    private BigFormat() {
    }

    @Override
    public Version getLatestVersion() {
        return latestVersion;
    }

    @Override
    public Version getVersion(String version) {
        return new BigVersion(version);
    }

    @Override
    public SSTableWriter.Factory getWriterFactory() {
        return writerFactory;
    }

    @Override
    public SSTableReader.Factory getReaderFactory() {
        return readerFactory;
    }

    public RowIndexEntry.IndexSerializer getIndexSerializer(CFMetaData metadata, Version version, SerializationHeader header) {
        return new RowIndexEntry.Serializer(metadata, version, header);
    }

    static class BigVersion
    extends Version {
        public static final String current_version = "mc";
        public static final String earliest_supported_version = "jb";
        private final boolean isLatestVersion;
        private final boolean hasSamplingLevel;
        private final boolean newStatsFile;
        private final ChecksumType compressedChecksumType;
        private final ChecksumType uncompressedChecksumType;
        private final boolean hasRepairedAt;
        private final boolean tracksLegacyCounterShards;
        private final boolean newFileName;
        public final boolean storeRows;
        public final int correspondingMessagingVersion;
        public final boolean hasBoundaries;
        private final boolean hasOldBfHashOrder;
        private final boolean hasCommitLogLowerBound;
        private final boolean hasCommitLogIntervals;
        private final boolean hasCompactionAncestors;

        BigVersion(String version) {
            super(instance, version);
            this.isLatestVersion = version.compareTo(current_version) == 0;
            this.hasSamplingLevel = version.compareTo("ka") >= 0;
            this.newStatsFile = version.compareTo("ka") >= 0;
            ChecksumType checksumType = ChecksumType.CRC32;
            if (version.compareTo("ka") >= 0 && version.compareTo("ma") < 0) {
                checksumType = ChecksumType.Adler32;
            }
            this.uncompressedChecksumType = checksumType;
            checksumType = ChecksumType.CRC32;
            if (version.compareTo(earliest_supported_version) >= 0 && version.compareTo("ma") < 0) {
                checksumType = ChecksumType.Adler32;
            }
            this.compressedChecksumType = checksumType;
            this.hasRepairedAt = version.compareTo("ka") >= 0;
            this.tracksLegacyCounterShards = version.compareTo("ka") >= 0;
            this.newFileName = version.compareTo("la") >= 0;
            this.hasOldBfHashOrder = version.compareTo("ma") < 0;
            this.hasCompactionAncestors = version.compareTo("ma") < 0;
            this.storeRows = version.compareTo("ma") >= 0;
            this.correspondingMessagingVersion = this.storeRows ? 10 : 8;
            this.hasBoundaries = version.compareTo("ma") < 0;
            this.hasCommitLogLowerBound = version.compareTo("lb") >= 0 && version.compareTo("ma") < 0 || version.compareTo("mb") >= 0;
            this.hasCommitLogIntervals = version.compareTo(current_version) >= 0;
        }

        @Override
        public boolean isLatestVersion() {
            return this.isLatestVersion;
        }

        @Override
        public boolean hasSamplingLevel() {
            return this.hasSamplingLevel;
        }

        @Override
        public boolean hasNewStatsFile() {
            return this.newStatsFile;
        }

        @Override
        public ChecksumType compressedChecksumType() {
            return this.compressedChecksumType;
        }

        @Override
        public ChecksumType uncompressedChecksumType() {
            return this.uncompressedChecksumType;
        }

        @Override
        public boolean hasRepairedAt() {
            return this.hasRepairedAt;
        }

        @Override
        public boolean tracksLegacyCounterShards() {
            return this.tracksLegacyCounterShards;
        }

        @Override
        public boolean hasOldBfHashOrder() {
            return this.hasOldBfHashOrder;
        }

        @Override
        public boolean hasCompactionAncestors() {
            return this.hasCompactionAncestors;
        }

        @Override
        public boolean hasNewFileName() {
            return this.newFileName;
        }

        @Override
        public boolean hasCommitLogLowerBound() {
            return this.hasCommitLogLowerBound;
        }

        @Override
        public boolean hasCommitLogIntervals() {
            return this.hasCommitLogIntervals;
        }

        @Override
        public boolean storeRows() {
            return this.storeRows;
        }

        @Override
        public int correspondingMessagingVersion() {
            return this.correspondingMessagingVersion;
        }

        @Override
        public boolean hasBoundaries() {
            return this.hasBoundaries;
        }

        @Override
        public boolean isCompatible() {
            return this.version.compareTo(earliest_supported_version) >= 0 && this.version.charAt(0) <= current_version.charAt(0);
        }

        @Override
        public boolean isCompatibleForStreaming() {
            return this.isCompatible() && this.version.charAt(0) == current_version.charAt(0);
        }
    }

    static class ReaderFactory
    extends SSTableReader.Factory {
        ReaderFactory() {
        }

        @Override
        public SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, Long maxDataAge, StatsMetadata sstableMetadata, SSTableReader.OpenReason openReason, SerializationHeader header) {
            return new BigTableReader(descriptor, components, metadata, maxDataAge, sstableMetadata, openReason, header);
        }
    }

    static class WriterFactory
    extends SSTableWriter.Factory {
        WriterFactory() {
        }

        @Override
        public SSTableWriter open(Descriptor descriptor, long keyCount, long repairedAt, CFMetaData metadata, MetadataCollector metadataCollector, SerializationHeader header, Collection<SSTableFlushObserver> observers, LifecycleTransaction txn) {
            return new BigTableWriter(descriptor, keyCount, repairedAt, metadata, metadataCollector, header, observers, txn);
        }
    }
}

