/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.balancers;

import com.carrotsearch.ant.tasks.junit4.listeners.ExecutionTimesReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;

public class MergeHints
extends Task {
    private List resources = new ArrayList();
    private int historyLength = 10;
    private File file;

    public void setHistoryLength(int n) {
        if (n < 0) {
            throw new BuildException("History length must be >= 1: " + n);
        }
        this.historyLength = n;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void add(ResourceCollection resourceCollection) {
        if (resourceCollection instanceof FileSet) {
            FileSet fileSet = (FileSet)resourceCollection;
            fileSet.setProject(this.getProject());
        }
        this.resources.add(resourceCollection);
    }

    public void execute() {
        Map map = ExecutionTimesReport.mergeHints(this.resources, null);
        for (List list : map.values()) {
            while (list.size() > this.historyLength) {
                list.remove(0);
            }
        }
        try {
            ExecutionTimesReport.writeHints(this.file, map);
        }
        catch (IOException iOException) {
            throw new BuildException("Could not write updated hints file: " + this.file, (Throwable)iOException);
        }
    }
}

