/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.classification.ClassificationResult;
import org.apache.lucene.classification.document.DocumentClassifier;
import org.apache.lucene.classification.document.KNearestNeighborDocumentClassifier;
import org.apache.lucene.classification.document.SimpleNaiveBayesDocumentClassifier;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.update.processor.ClassificationUpdateProcessorFactory;
import org.apache.solr.update.processor.ClassificationUpdateProcessorParams;
import org.apache.solr.update.processor.UpdateRequestProcessor;

class ClassificationUpdateProcessor
extends UpdateRequestProcessor {
    private final String trainingClassField;
    private final String predictedClassField;
    private final int maxOutputClasses;
    private DocumentClassifier<BytesRef> classifier;

    public ClassificationUpdateProcessor(ClassificationUpdateProcessorParams classificationParams, UpdateRequestProcessor next, IndexReader indexReader, IndexSchema schema) {
        super(next);
        String[] inputFieldNames;
        this.trainingClassField = classificationParams.getTrainingClassField();
        this.predictedClassField = classificationParams.getPredictedClassField();
        this.maxOutputClasses = classificationParams.getMaxPredictedClasses();
        String[] inputFieldNamesWithBoost = classificationParams.getInputFieldNames();
        ClassificationUpdateProcessorFactory.Algorithm classificationAlgorithm = classificationParams.getAlgorithm();
        HashMap<String, Analyzer> field2analyzer = new HashMap<String, Analyzer>();
        for (String fieldName : inputFieldNames = this.removeBoost(inputFieldNamesWithBoost)) {
            SchemaField fieldFromSolrSchema = schema.getField(fieldName);
            Analyzer indexAnalyzer = fieldFromSolrSchema.getType().getQueryAnalyzer();
            field2analyzer.put(fieldName, indexAnalyzer);
        }
        switch (classificationAlgorithm) {
            case KNN: {
                this.classifier = new KNearestNeighborDocumentClassifier(indexReader, null, classificationParams.getTrainingFilterQuery(), classificationParams.getK(), classificationParams.getMinDf(), classificationParams.getMinTf(), this.trainingClassField, field2analyzer, inputFieldNamesWithBoost);
                break;
            }
            case BAYES: {
                this.classifier = new SimpleNaiveBayesDocumentClassifier(indexReader, null, this.trainingClassField, field2analyzer, inputFieldNamesWithBoost);
            }
        }
    }

    private String[] removeBoost(String[] inputFieldNamesWithBoost) {
        String[] inputFieldNames = new String[inputFieldNamesWithBoost.length];
        for (int i = 0; i < inputFieldNamesWithBoost.length; ++i) {
            String singleFieldNameWithBoost = inputFieldNamesWithBoost[i];
            String[] fieldName2boost = singleFieldNameWithBoost.split("\\^");
            inputFieldNames[i] = fieldName2boost[0];
        }
        return inputFieldNames;
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        Document luceneDocument;
        List assignedClassifications;
        SolrInputDocument doc = cmd.getSolrInputDocument();
        Object documentClass = doc.getFieldValue(this.trainingClassField);
        if (documentClass == null && (assignedClassifications = this.classifier.getClasses(luceneDocument = DocumentBuilder.toDocument(doc, cmd.getReq().getSchema(), false, true), this.maxOutputClasses)) != null) {
            for (ClassificationResult singleClassification : assignedClassifications) {
                String assignedClass = ((BytesRef)singleClassification.getAssignedClass()).utf8ToString();
                doc.addField(this.predictedClassField, (Object)assignedClass);
            }
        }
        super.processAdd(cmd);
    }
}

