/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util.path;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.activemq.apollo.util.path.Path;
import org.apache.activemq.apollo.util.path.PathMapNode;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\t9\u0001+\u0019;i\u001b\u0006\u0004(BA\u0002\u0005\u0003\u0011\u0001\u0018\r\u001e5\u000b\u0005\u00151\u0011\u0001B;uS2T!a\u0002\u0005\u0002\r\u0005\u0004x\u000e\u001c7p\u0015\tI!\"\u0001\u0005bGRLg/Z7r\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001CJ\n\u0004\u0001EI\u0002C\u0001\n\u0018\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003\u0011a\u0017M\\4\u000b\u0003Y\tAA[1wC&\u0011\u0001d\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u00022a\t\u0001%\u001b\u0005\u0011\u0001CA\u0013'\u0019\u0001!Qa\n\u0001C\u0002!\u0012QAV1mk\u0016\f\"!\u000b\u0017\u0011\u0005iQ\u0013BA\u0016\u001c\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AG\u0017\n\u00059Z\"aA!os\")\u0001\u0007\u0001C\u0001c\u0005\u0019q-\u001a;\u0015\u0005I:\u0004cA\u001a6I5\tAG\u0003\u0002\u0006+%\u0011a\u0007\u000e\u0002\u0004'\u0016$\b\"\u0002\u001d0\u0001\u0004I\u0014aA6fsB\u00111EO\u0005\u0003w\t\u0011A\u0001U1uQ\")Q\b\u0001C\u0001}\u0005\u0019\u0001/\u001e;\u0015\u0007}\u00125\t\u0005\u0002\u001b\u0001&\u0011\u0011i\u0007\u0002\u0005+:LG\u000fC\u00039y\u0001\u0007\u0011\bC\u0003Ey\u0001\u0007A%A\u0003wC2,X\rC\u0003G\u0001\u0011\u0005q)\u0001\u0004sK6|g/\u001a\u000b\u0004\u0011.c\u0005C\u0001\u000eJ\u0013\tQ5DA\u0004C_>dW-\u00198\t\u000b\r)\u0005\u0019A\u001d\t\u000b\u0011+\u0005\u0019\u0001\u0013\t\u000b9\u0003A\u0011A(\u0002\u0017\u001d,GOU8pi:{G-Z\u000b\u0002!B\u00191%\u0015\u0013\n\u0005I\u0013!a\u0003)bi\"l\u0015\r\u001d(pI\u0016DQ\u0001\u0016\u0001\u0005\u0012U\u000b1CZ5oI^KG\u000eZ2be\u0012l\u0015\r^2iKN$\"A\r,\t\u000b\r\u0019\u0006\u0019A\u001d\t\u000ba\u0003A\u0011A-\u0002\u0013I,Wn\u001c<f\u00032dGC\u0001\u001a[\u0011\u0015At\u000b1\u0001:\u0011\u0015a\u0006\u0001\"\u0001^\u0003-\u0019\u0007n\\8tKZ\u000bG.^3\u0015\u0005\u0011r\u0006\"B\u0002\\\u0001\u0004I\u0004b\u00021\u0001\u0005\u0004%iaT\u0001\u0005e>|G\u000f\u0003\u0004c\u0001\u0001\u0006i\u0001U\u0001\u0006e>|G\u000f\t")
public class PathMap<Value>
implements ScalaObject {
    private final PathMapNode<Value> root = new PathMapNode(null);

    public Set<Value> get(Path key) {
        return this.findWildcardMatches(key);
    }

    public void put(Path key, Value value) {
        this.root().add(key, 0, value);
    }

    public boolean remove(Path path, Value value) {
        return this.root().remove(path, 0, value);
    }

    public PathMapNode<Value> getRootNode() {
        return this.root();
    }

    public Set<Value> findWildcardMatches(Path path) {
        HashSet answer = new HashSet();
        this.root().appendMatchingValues(answer, path, 0);
        return answer;
    }

    public Set<Value> removeAll(Path key) {
        HashSet rc = new HashSet();
        this.root().removeAll(rc, key, 0);
        return rc;
    }

    public Value chooseValue(Path path) {
        Set<Value> set = this.get(path);
        if (set == null || set.isEmpty()) {
            return null;
        }
        Value first = set.iterator().next();
        if (set.size() != 1 && first instanceof Comparable) {
            TreeSet<Value> sortedSet = new TreeSet<Value>(set);
            return (Value)sortedSet.last();
        }
        return first;
    }

    private final PathMapNode<Value> root() {
        return this.root;
    }
}

