/*****
 NAME
	pobject.h - protocol definition for Object class group
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(POBJECT_H_INCLUDED)
#define	POBJECT_H_INCLUDED

#include <coconut/dbasic.h>
#include <coconut/tbasic.h>
#include <coconut/tglib.h>

#ifdef __APPLE__
#	include <Foundation/NSObject.h>
#	define	OBJECT	NSObject
#else
	/* note: "objc/Object.h" refers "strcmp" function. */
#	include <string.h>
#	include <objc/Protocol.h> 
#	include <objc/objc.h>
#	include <objc/Object.h>
#	define	OBJECT	Object
#endif

#include <coconut/dobject.h>

/*****
 PROTOCOL:
 	PObject
 DESCRIPTION:
 	The "PObject" protocol will be implemented by all of the objects
	in the coconut library.
 */
@protocol PObject

  /****
    Initialize the state of the object.
    This method is designed to be called after "alloc" method.
   */
  - init ;

  /*****
    Deallocate the all object in the object and itself.
    DO NOT call this method to deallocate the object.
    Use "release" method.
   */
  - (void) dealloc ;

# if !defined(__APPLE__)
  - retain ;
  - autorelease ;
  - (oneway void) release ;
  - (unsigned int) retainCount ;
# endif
@end

#endif	/* !defined(POBJECT_H_INCLUDED) */

