/*****
 NAME
 	tglib.h - wrapper type definition for glib
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(TGLIB_H_INCLUDED)
#define TGLIB_H_INCLUDED

#include <coconut/dconfig.h>
#if defined(COCONUT_HAVE_GLIB_CONFIG)
   /* do not use old API */
#  define G_DISABLE_DEPRECATED
#  include <glib.h>
#else
#  error "glib package required"
#endif

/* 
 * for error operation
 */

/* if you pass the null pointer as GError *, use this one */
#define	ERROR_NULL		NULL

/* 
 * for hash operation
 */

/* int (*compare_func_t)(const void * s1, const void * s2) ; */
typedef GCompareFunc    compare_func_t ;
/* gboolean (*equal_func_t)(gconstpointer a, gconstpointer b) */
typedef	GEqualFunc	equal_func_t ;
/* void (*remove_func_t)(gpointer data) */
typedef GDestroyNotify	remove_func_t ;

/* unsigned int (*hash_func_t)(const void * p) ; */
typedef GHashFunc       hash_func_t ;
/* gboolean  (*GHRFunc)(gpointer key, gpointer value, gpointer user_data); */
typedef GHRFunc		hash_remove_func_t ;

/* 
 * for iochannel operation
 */

typedef GIOStatus		io_status_t ;
#define	io_status_error		G_IO_STATUS_ERROR
#define	io_status_normal	G_IO_STATUS_NORMAL
#define	io_status_eof		G_IO_STATUS_EOF
#define	io_status_again		G_IO_STATUS_AGAIN

typedef	GIOCondition		io_condition_t ;
#define	io_condition_in		G_IO_IN
#define	io_condition_out	G_IO_OUT
#define	io_condition_pri	G_IO_PRI
#define	io_condition_error	G_IO_ERR
#define	io_condition_hungup	G_IO_HUP
#define	io_condition_invalid	G_IO_NVAL

#define	IS_IO_ERROR_CONDITION(cond)	((cond) & (G_IO_ERR | G_IO_HUP))
#define	IS_IO_INPUT_CONDITION(cond)	((cond) & G_IO_IN)
#define	IS_IO_OUTPUT_CONDITION(cond)	((cond) & G_IO_OUT)

#endif /* TGLIB_H_INCLUDED */

