/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.indices.mapping.put.MappingRequestValidator;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.ccr.CcrSettings;

public final class CcrRequests {
    public static final MappingRequestValidator CCR_PUT_MAPPING_REQUEST_VALIDATOR = (request, state, indices) -> {
        if (request.origin() == null) {
            return null;
        }
        List followingIndices = Arrays.stream(indices).filter(index -> {
            IndexMetaData indexMetaData = state.metaData().index(index);
            return indexMetaData != null && (Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(indexMetaData.getSettings()) != false;
        }).collect(Collectors.toList());
        if (!followingIndices.isEmpty() && !"ccr".equals(request.origin())) {
            String errorMessage = "can't put mapping to the following indices [" + followingIndices.stream().map(Index::getName).collect(Collectors.joining(", ")) + "]; the mapping of the following indices are self-replicated from its leader indices";
            return new ElasticsearchStatusException(errorMessage, RestStatus.FORBIDDEN, new Object[0]);
        }
        return null;
    };

    private CcrRequests() {
    }

    public static ClusterStateRequest metaDataRequest(String leaderIndex) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear();
        clusterStateRequest.metaData(true);
        clusterStateRequest.indices(new String[]{leaderIndex});
        return clusterStateRequest;
    }

    public static PutMappingRequest putMappingRequest(String followerIndex, MappingMetaData mappingMetaData) {
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{followerIndex});
        putMappingRequest.origin("ccr");
        putMappingRequest.type(mappingMetaData.type());
        putMappingRequest.source(mappingMetaData.source().string(), XContentType.JSON);
        return putMappingRequest;
    }

    public static void getIndexMetadata(Client client, Index index, long mappingVersion, long metadataVersion, Supplier<TimeValue> timeoutSupplier, ActionListener<IndexMetaData> listener) {
        ClusterStateRequest request = CcrRequests.metaDataRequest(index.getName());
        if (metadataVersion > 0L) {
            request.waitForMetaDataVersion(metadataVersion).waitForTimeout(timeoutSupplier.get());
        }
        client.admin().cluster().state(request, ActionListener.wrap(response -> {
            if (response.getState() == null) {
                assert (metadataVersion > 0L) : metadataVersion;
                if (((TimeValue)timeoutSupplier.get()).nanos() < 0L) {
                    listener.onFailure((Exception)new IllegalStateException("timeout to get cluster state with metadata version [" + metadataVersion + "], mapping version [" + mappingVersion + "]"));
                } else {
                    CcrRequests.getIndexMetadata(client, index, mappingVersion, metadataVersion, timeoutSupplier, listener);
                }
            } else {
                MetaData metaData = response.getState().metaData();
                IndexMetaData indexMetaData = metaData.getIndexSafe(index);
                if (indexMetaData.getMappingVersion() >= mappingVersion) {
                    listener.onResponse((Object)indexMetaData);
                    return;
                }
                if (((TimeValue)timeoutSupplier.get()).nanos() < 0L) {
                    listener.onFailure((Exception)new IllegalStateException("timeout to get cluster state with mapping version [" + mappingVersion + "]"));
                } else {
                    CcrRequests.getIndexMetadata(client, index, mappingVersion, metaData.version() + 1L, timeoutSupplier, listener);
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

