/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.chunked;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;

class ChunkedDataExtractorContext {
    final String jobId;
    final String timeField;
    final String[] indices;
    final String[] types;
    final QueryBuilder query;
    final int scrollSize;
    final long start;
    final long end;
    final TimeValue chunkSpan;
    final TimeAligner timeAligner;
    final Map<String, String> headers;
    final boolean hasAggregations;
    final Long histogramInterval;

    ChunkedDataExtractorContext(String jobId, String timeField, List<String> indices, List<String> types, QueryBuilder query, int scrollSize, long start, long end, @Nullable TimeValue chunkSpan, TimeAligner timeAligner, Map<String, String> headers, boolean hasAggregations, @Nullable Long histogramInterval) {
        this.jobId = Objects.requireNonNull(jobId);
        this.timeField = Objects.requireNonNull(timeField);
        this.indices = indices.toArray(new String[indices.size()]);
        this.types = types.toArray(new String[types.size()]);
        this.query = Objects.requireNonNull(query);
        this.scrollSize = scrollSize;
        this.start = start;
        this.end = end;
        this.chunkSpan = chunkSpan;
        this.timeAligner = Objects.requireNonNull(timeAligner);
        this.headers = headers;
        this.hasAggregations = hasAggregations;
        this.histogramInterval = histogramInterval;
    }

    static interface TimeAligner {
        public long alignToFloor(long var1);

        public long alignToCeil(long var1);
    }
}

