/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.sql.ClientSqlException;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.Node;

public class AnalysisException
extends ClientSqlException {
    private final int line;
    private final int column;

    public AnalysisException(Node<?> source, String message, Object ... args) {
        super(message, args);
        Location loc = Location.EMPTY;
        if (source != null && source.source() != null) {
            loc = source.source().source();
        }
        this.line = loc.getLineNumber();
        this.column = loc.getColumnNumber();
    }

    public AnalysisException(Node<?> source, String message, Throwable cause) {
        super(message, cause);
        Location loc = Location.EMPTY;
        if (source != null && source.source() != null) {
            loc = source.source().source();
        }
        this.line = loc.getLineNumber();
        this.column = loc.getColumnNumber();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public String getMessage() {
        return LoggerMessageFormat.format((String)"line {}:{}: {}", (Object[])new Object[]{this.getLineNumber(), this.getColumnNumber(), super.getMessage()});
    }
}

