/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class TLSv1DeprecationHandler {
    private final String supportedProtocolsSetting;
    private final boolean shouldLogWarnings;
    private final DeprecationLogger deprecationLogger;

    public TLSv1DeprecationHandler(String settingPrefix, Settings settings, Logger baseLogger) {
        if (settingPrefix.length() > 0 && !settingPrefix.endsWith("ssl.")) {
            throw new IllegalArgumentException("Setting prefix [" + settingPrefix + "] must end in 'ssl.'");
        }
        this.supportedProtocolsSetting = settingPrefix + "supported_protocols";
        this.shouldLogWarnings = !SSLConfigurationSettings.SUPPORTED_PROTOCOLS_TEMPLATE.apply(this.supportedProtocolsSetting).exists(settings);
        this.deprecationLogger = this.shouldLogWarnings ? new DeprecationLogger(baseLogger) : null;
    }

    private TLSv1DeprecationHandler(String settingKey, boolean shouldLog, DeprecationLogger logger) {
        this.supportedProtocolsSetting = settingKey;
        this.shouldLogWarnings = shouldLog;
        this.deprecationLogger = logger;
    }

    public static TLSv1DeprecationHandler disabled() {
        return new TLSv1DeprecationHandler(null, false, null);
    }

    public boolean shouldLogWarnings() {
        return this.shouldLogWarnings;
    }

    public void checkAndLog(SSLSession session, Supplier<String> descriptionSupplier) {
        if (!this.shouldLogWarnings) {
            return;
        }
        if ("TLSv1".equals(session.getProtocol())) {
            String description = descriptionSupplier.get();
            String key = LocalDate.now(ZoneId.of("UTC")) + ":" + description;
            this.deprecationLogger.deprecatedAndMaybeLog(key, "a TLS v1.0 session was used for [{}], this protocol will be disabled by default in a future version. The [{}] setting can be used to control this.", new Object[]{description, this.supportedProtocolsSetting});
        }
    }
}

