/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleRunner;

public class MoveToErrorStepUpdateTask
extends ClusterStateUpdateTask {
    private final Index index;
    private final String policy;
    private final Step.StepKey currentStepKey;
    private LongSupplier nowSupplier;
    private Exception cause;

    public MoveToErrorStepUpdateTask(Index index, String policy, Step.StepKey currentStepKey, Exception cause, LongSupplier nowSupplier) {
        this.index = index;
        this.policy = policy;
        this.currentStepKey = currentStepKey;
        this.cause = cause;
        this.nowSupplier = nowSupplier;
    }

    Index getIndex() {
        return this.index;
    }

    String getPolicy() {
        return this.policy;
    }

    Step.StepKey getCurrentStepKey() {
        return this.currentStepKey;
    }

    Exception getCause() {
        return this.cause;
    }

    public ClusterState execute(ClusterState currentState) throws IOException {
        IndexMetaData idxMeta = currentState.getMetaData().index(this.index);
        if (idxMeta == null) {
            return currentState;
        }
        Settings indexSettings = idxMeta.getSettings();
        LifecycleExecutionState indexILMData = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)idxMeta);
        if (this.policy.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings)) && this.currentStepKey.equals((Object)IndexLifecycleRunner.getCurrentStepKey(indexILMData))) {
            return IndexLifecycleRunner.moveClusterStateToErrorStep(this.index, currentState, this.currentStepKey, this.cause, this.nowSupplier);
        }
        return currentState;
    }

    public void onFailure(String source, Exception e) {
        throw new ElasticsearchException("policy [" + this.policy + "] for index [" + this.index.getName() + "] failed trying to move from step [" + this.currentStepKey + "] to the ERROR step.", (Throwable)e, new Object[0]);
    }
}

