/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.rollup.RollupFeatureSetUsage;

public class RollupFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public RollupFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.ROLLUP_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "rollup";
    }

    public String description() {
        return "Time series pre-aggregation and rollup";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isRollupAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new RollupFeatureSetUsage(this.available(), this.enabled()));
    }
}

