/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.nav;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.nav.NavHandler;
import com.adobe.epubcheck.opf.PublicationResourceChecker;
import com.adobe.epubcheck.opf.PublicationType;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ValidatorMap;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public class NavChecker
extends PublicationResourceChecker {
    private static final ValidatorMap validatorMap = ValidatorMap.builder().putAll(XMLValidators.NAV_30_RNC, XMLValidators.XHTML_30_SCH, XMLValidators.NAV_30_SCH).putAll((Predicate<? super ValidationContext>)Predicates.and((Predicate[])new Predicate[]{Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.EDUPUB), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.EDUPUB)), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.FIXED_LAYOUT))), Predicates.not(ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR)))}), XMLValidators.XHTML_EDUPUB_STRUCTURE_SCH, XMLValidators.XHTML_EDUPUB_SEMANTICS_SCH, XMLValidators.XHTML_IDX_SCH).putAll((Predicate<? super ValidationContext>)Predicates.and((Predicate[])new Predicate[]{Predicates.or(ValidationContext.ValidationContextPredicates.profile(EPUBProfile.DICT), ValidationContext.ValidationContextPredicates.hasPubType(PublicationType.DICTIONARY)), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)}), XMLValidators.XHTML_DICT_SCH).putAll((Predicate<? super ValidationContext>)Predicates.and((Predicate[])new Predicate[]{Predicates.or(ValidationContext.ValidationContextPredicates.hasProp(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.INDEX)), ValidationContext.ValidationContextPredicates.hasProp(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.IN_INDEX_COLLECTION))), ValidationContext.ValidationContextPredicates.mimetype("application/xhtml+xml"), ValidationContext.ValidationContextPredicates.version(EPUBVersion.VERSION_3)}), XMLValidators.XHTML_IDX_SCH, XMLValidators.XHTML_IDX_INDEX_SCH).build();

    public NavChecker(ValidationContext context) {
        super(context);
        Preconditions.checkState((boolean)"application/xhtml+xml".equals(context.mimeType));
        if (context.version == EPUBVersion.VERSION_2) {
            context.report.message(MessageId.NAV_001, EPUBLocation.of(context), new Object[0]);
        }
    }

    @Override
    protected boolean checkContent() {
        XMLParser navParser = new XMLParser(this.context);
        navParser.addContentHandler(new NavHandler(this.context));
        for (XMLValidator validator : validatorMap.getValidators(this.context)) {
            navParser.addValidator(validator);
        }
        navParser.process();
        return true;
    }
}

